/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Authentication;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class ActiveDirectory {
    private static String[] userAttributes = new String[]{"distinguishedName", "cn", "name", "uid", "sn", "givenname", "memberOf", "samaccountname", "userPrincipalName"};

    private ActiveDirectory() {
    }

    public static LdapContext getConnection(String string, String string2) throws NamingException {
        return ActiveDirectory.getConnection(string, string2, null, null);
    }

    public static LdapContext getConnection(String string, String string2, String string3) throws NamingException {
        return ActiveDirectory.getConnection(string, string2, string3, null);
    }

    public static LdapContext getConnection(String string, String string2, String string3, String string4) throws NamingException {
        Object object;
        if (string3 == null) {
            try {
                object = InetAddress.getLocalHost().getCanonicalHostName();
                if (((String)object).split("\\.").length > 1) {
                    string3 = ((String)object).substring(((String)object).indexOf(".") + 1);
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (string2 != null && (string2 = string2.trim()).length() == 0) {
            string2 = null;
        }
        object = new Hashtable();
        String string5 = string + "@" + string3;
        ((Hashtable)object).put("java.naming.security.principal", string5);
        if (string2 != null) {
            ((Hashtable)object).put("java.naming.security.credentials", string2);
        }
        String string6 = "ldap://" + (String)(string4 == null ? string3 : string4 + "." + string3) + "/";
        ((Hashtable)object).put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        ((Hashtable)object).put("java.naming.provider.url", string6);
        try {
            return new InitialLdapContext((Hashtable<?, ?>)object, null);
        }
        catch (CommunicationException communicationException) {
            throw new NamingException("Failed to connect to " + string3 + (String)(string4 == null ? "" : " through " + string4));
        }
        catch (NamingException namingException) {
            throw new NamingException("Failed to authenticate " + string + "@" + string3 + (String)(string4 == null ? "" : " through " + string4));
        }
    }

    public static User getUser(String string, LdapContext ldapContext) {
        try {
            Object object;
            String string2 = null;
            if (string.contains("@")) {
                string = string.substring(0, string.indexOf("@"));
                string2 = string.substring(string.indexOf("@") + 1);
            } else if (string.contains("\\")) {
                string = string.substring(0, string.indexOf("\\"));
                string2 = string.substring(string.indexOf("\\") + 1);
            } else {
                object = (String)ldapContext.getEnvironment().get("java.naming.security.principal");
                if (((String)object).contains("@")) {
                    string2 = ((String)object).substring(((String)object).indexOf("@") + 1);
                }
            }
            if (string2 != null) {
                Attributes attributes;
                Attribute attribute;
                object = string + "@" + string2;
                SearchControls searchControls = new SearchControls();
                searchControls.setSearchScope(2);
                searchControls.setReturningAttributes(userAttributes);
                NamingEnumeration<SearchResult> namingEnumeration = ldapContext.search(ActiveDirectory.toDC(string2), "(& (userPrincipalName=" + (String)object + ")(objectClass=user))", searchControls);
                if (namingEnumeration.hasMore() && (attribute = (attributes = namingEnumeration.next().getAttributes()).get("userPrincipalName")) != null) {
                    return new User(attributes);
                }
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return null;
    }

    public static User[] getUsers(LdapContext ldapContext) throws NamingException {
        ArrayList<User> arrayList = new ArrayList<User>();
        String string = (String)ldapContext.getEnvironment().get("java.naming.security.principal");
        if (string.contains("@")) {
            String string2 = string.substring(string.indexOf("@") + 1);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setReturningAttributes(userAttributes);
            NamingEnumeration<SearchResult> namingEnumeration = ldapContext.search(ActiveDirectory.toDC(string2), "(objectClass=user)", searchControls);
            try {
                while (namingEnumeration.hasMore()) {
                    Attributes attributes = namingEnumeration.next().getAttributes();
                    Attribute attribute = attributes.get("userPrincipalName");
                    if (attribute == null) continue;
                    arrayList.add(new User(attributes));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return arrayList.toArray(new User[arrayList.size()]);
    }

    private static String toDC(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : string.split("\\.")) {
            if (string2.length() == 0) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("DC=").append(string2);
        }
        return stringBuilder.toString();
    }

    public static class User {
        private String distinguishedName;
        private String userPrincipal;
        private String commonName;
        private static final HostnameVerifier DO_NOT_VERIFY = new HostnameVerifier(){

            @Override
            public boolean verify(String string, SSLSession sSLSession) {
                return true;
            }
        };
        private static TrustManager[] TRUST_ALL_CERTS = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
            }
        }};

        public User(Attributes attributes) throws NamingException {
            this.userPrincipal = (String)attributes.get("userPrincipalName").get();
            this.commonName = (String)attributes.get("cn").get();
            this.distinguishedName = (String)attributes.get("distinguishedName").get();
        }

        public String getUserPrincipal() {
            return this.userPrincipal;
        }

        public String getCommonName() {
            return this.commonName;
        }

        public String getDistinguishedName() {
            return this.distinguishedName;
        }

        public String toString() {
            return this.getDistinguishedName();
        }

        public void changePassword(String string, String string2, boolean bl, LdapContext ldapContext) throws IOException, NamingException {
            Object object;
            ModificationItem[] modificationItemArray;
            String string3 = this.getDistinguishedName();
            StartTlsResponse startTlsResponse = null;
            try {
                startTlsResponse = (StartTlsResponse)ldapContext.extendedOperation(new StartTlsRequest());
            }
            catch (Exception exception) {
                throw new IOException("Failed to establish SSL connection to the Domain Controller. Is LDAPS enabled?");
            }
            if (bl) {
                startTlsResponse.setHostnameVerifier(DO_NOT_VERIFY);
                modificationItemArray = null;
                try {
                    object = SSLContext.getInstance("TLS");
                    ((SSLContext)object).init(null, TRUST_ALL_CERTS, null);
                    modificationItemArray = ((SSLContext)object).getSocketFactory();
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                }
                catch (KeyManagementException keyManagementException) {
                    // empty catch block
                }
                startTlsResponse.negotiate((SSLSocketFactory)modificationItemArray);
            } else {
                startTlsResponse.negotiate();
            }
            try {
                modificationItemArray = new ModificationItem[]{new ModificationItem(3, new BasicAttribute("unicodePwd", this.getPassword(string))), new ModificationItem(1, new BasicAttribute("unicodePwd", this.getPassword(string2)))};
                ldapContext.modifyAttributes(string3, modificationItemArray);
            }
            catch (InvalidAttributeValueException invalidAttributeValueException) {
                object = invalidAttributeValueException.getMessage().trim();
                if (((String)object).startsWith("[") && ((String)object).endsWith("]")) {
                    object = ((String)object).substring(1, ((String)object).length() - 1);
                }
                System.err.println((String)object);
                startTlsResponse.close();
                throw new NamingException("New password does not meet Active Directory requirements. Please ensure that the new password meets password complexity, length, minimum password age, and password history requirements.");
            }
            catch (NamingException namingException) {
                startTlsResponse.close();
                throw namingException;
            }
            startTlsResponse.close();
        }

        private byte[] getPassword(String string) {
            String string2 = "\"" + string + "\"";
            char[] cArray = string2.toCharArray();
            byte[] byArray = new byte[cArray.length * 2];
            for (int i = 0; i < cArray.length; ++i) {
                byArray[i * 2 + 1] = (byte)(cArray[i] >>> 8);
                byArray[i * 2 + 0] = (byte)(cArray[i] & 0xFF);
            }
            return byArray;
        }
    }
}

