/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Certificate;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.CSV.Csv;
import au.com.aemo.Common.Certificate.CertificateDetail;
import au.com.aemo.Common.Certificate.CertificateStoreConfig;
import au.com.aemo.Common.Certificate.WebServerConnectivity;
import au.com.aemo.Common.Files.FileUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.Key;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateUtilities {
    private static final int EXPIRY_DATE_WARNING_DAYS = 90;
    private CertificateStoreConfig itsCertStoreConfig;
    protected SSLContext itsSSLContext;
    private static Logger logger = LoggerFactory.getLogger(CertificateUtilities.class);

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Method is consumed by trusted code")
    public void setCertStoreConfig(CertificateStoreConfig certificateStoreConfig) throws Exception {
        this.itsCertStoreConfig = certificateStoreConfig;
        KeyStore keyStore = this.loadKeystore();
        if (keyStore != null) {
            try {
                this.itsSSLContext = this.getSslContext(keyStore);
            }
            catch (Exception exception) {
                Util_Logger.error(logger, "Error re-generating SSL context after updates to keystore [" + this.itsCertStoreConfig.KeyStoreFile + "]: " + exception.getMessage(), exception);
            }
        }
    }

    public void createCertificate(String string, int n, String string2) throws ApplicationException {
        try {
            String[] stringArray;
            boolean bl = System.getProperty("os.name").toLowerCase().startsWith("windows");
            String string3 = bl ? "cmd" : "/bin/bash";
            String string4 = bl ? "/c" : "-c";
            String string5 = string2;
            if (Util.isBlank(string5)) {
                stringArray = new StringBuilder("SAN=ip:127.0.0.1,dns:localhost");
                stringArray.append(",ip:");
                stringArray.append(InetAddress.getLocalHost().getHostAddress());
                stringArray.append(",dns:");
                stringArray.append(InetAddress.getLocalHost().getHostName());
                string5 = stringArray.toString();
            }
            stringArray = new String[]{string3, string4, String.join((CharSequence)" ", "keytool", "-genkeypair", "-keyalg", "RSA", "-keysize", "2048", "-validity", Integer.toString(n), "-alias", string, "-dname", "CN=" + string + ",OU=DataInterchange,O=AEMO,L=Melbourne,ST=Victoria,C=AU", "-keystore", this.itsCertStoreConfig.KeyStoreFile, "-storetype", this.itsCertStoreConfig.KeyStoreType, "-storepass", this.itsCertStoreConfig.StorePassword, "-keypass", this.itsCertStoreConfig.KeyPassword, "-ext", string5)};
            ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
            processBuilder.directory(new File(".")).redirectErrorStream(true);
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            StringBuilder stringBuilder = new StringBuilder();
            Scanner scanner = new Scanner(process.getInputStream());
            while (scanner.hasNextLine()) {
                String string6 = scanner.nextLine();
                stringBuilder.append(string6);
                stringBuilder.append("\n");
            }
            process.waitFor();
            if (process.exitValue() != 0) {
                throw new Exception(stringBuilder.toString());
            }
            Util_Logger.info(logger, "Created certificate: " + stringBuilder.toString());
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error Creating certificate: " + exception.getMessage(), exception);
        }
    }

    public KeyStore loadKeystore() throws Exception {
        KeyStore keyStore;
        block14: {
            if (this.itsCertStoreConfig == null) {
                throw new IllegalArgumentException("Key store configuration must be defined for HTTPS protocol");
            }
            if (Util.isBlank(this.itsCertStoreConfig.KeyStoreFile)) {
                throw new IllegalArgumentException("Key store file must be defined for HTTPS protocol");
            }
            if (Util.isBlank(this.itsCertStoreConfig.StorePassword)) {
                throw new IllegalArgumentException("Store password must be defined for HTTPS protocol");
            }
            keyStore = null;
            try {
                char[] cArray = this.itsCertStoreConfig.StorePassword.toCharArray();
                if (Files.exists(Paths.get(this.itsCertStoreConfig.KeyStoreFile, new String[0]), new LinkOption[0])) {
                    keyStore = KeyStore.getInstance(this.itsCertStoreConfig.KeyStoreType);
                    try (FileInputStream fileInputStream = new FileInputStream(this.itsCertStoreConfig.KeyStoreFile);){
                        keyStore.load(fileInputStream, cArray);
                    }
                    Util_Logger.info(logger, "Loaded keystore from [" + this.itsCertStoreConfig.KeyStoreFile + "]");
                    break block14;
                }
                if (this.itsCertStoreConfig.AllowToCreate.booleanValue()) {
                    keyStore = KeyStore.getInstance(this.itsCertStoreConfig.KeyStoreType);
                    keyStore.load(null, cArray);
                } else {
                    Util_Logger.error(logger, "Error loading keystore from [" + this.itsCertStoreConfig.KeyStoreFile + "], file not found");
                }
            }
            catch (Exception exception) {
                Util_Logger.error(logger, "Error loading keystore from [" + this.itsCertStoreConfig.KeyStoreFile + "]: " + exception.getMessage(), exception);
            }
        }
        return keyStore;
    }

    public synchronized void saveKeystore(KeyStore keyStore) throws ApplicationException {
        Object object;
        try {
            if (Files.exists(Paths.get(this.itsCertStoreConfig.KeyStoreFile, new String[0]), new LinkOption[0])) {
                object = this.itsCertStoreConfig.KeyStoreFile + "." + Util.dateToStr(new Date(), "yyyyMMddHHmmss");
                FileUtilities.copy(new File(this.itsCertStoreConfig.KeyStoreFile), new File((String)object));
                Util_Logger.info(logger, "Keystore file backed up to " + (String)object);
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error backuping up keystore [" + this.itsCertStoreConfig.KeyStoreFile + "]: " + exception.getMessage(), exception);
        }
        try {
            object = new FileOutputStream(this.itsCertStoreConfig.KeyStoreFile);
            try {
                char[] cArray = this.itsCertStoreConfig.StorePassword.toCharArray();
                keyStore.store((OutputStream)object, cArray);
                Util_Logger.info(logger, "Keystore save to [" + this.itsCertStoreConfig.KeyStoreFile + "]");
            }
            finally {
                ((FileOutputStream)object).close();
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error loading keystore from [" + this.itsCertStoreConfig.KeyStoreFile + "]: " + exception.getMessage(), exception);
        }
        try {
            this.itsSSLContext = this.getSslContext(keyStore);
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error re-generating SSL context after updates to keystore [" + this.itsCertStoreConfig.KeyStoreFile + "]: " + exception.getMessage(), exception);
        }
    }

    public List<CertificateDetail> getCertificateList() throws ApplicationException {
        ArrayList<CertificateDetail> arrayList = new ArrayList<CertificateDetail>();
        if (this.itsCertStoreConfig != null) {
            try {
                KeyStore keyStore = this.loadKeystore();
                Enumeration<String> enumeration = keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    String string = enumeration.nextElement();
                    Certificate certificate = keyStore.getCertificate(string);
                    if (!(certificate instanceof X509Certificate)) continue;
                    X509Certificate x509Certificate = (X509Certificate)certificate;
                    CertificateDetail certificateDetail = this.getCertificateDetail(x509Certificate);
                    certificateDetail.Alias = string;
                    arrayList.add(certificateDetail);
                }
            }
            catch (Exception exception) {
                Util_Logger.error(logger, "Error listing certificates from keystore [" + this.itsCertStoreConfig.KeyStoreFile + "]: " + exception.getMessage(), exception);
            }
        }
        return arrayList;
    }

    public void logCertificates(String string) {
        if (this.itsCertStoreConfig != null) {
            try {
                Date date = Util.dateOffset(new Date(), 90, 5);
                Util_Logger.info(logger, "Generating certificate report from keystore [" + this.itsCertStoreConfig.KeyStoreFile + "] with expiry warning of 90 days [" + Util.dateToStr(date, "dd/MM/yyyy") + "]");
                KeyStore keyStore = this.loadKeystore();
                Enumeration<String> enumeration = keyStore.aliases();
                boolean bl = false;
                while (enumeration.hasMoreElements()) {
                    String string2 = enumeration.nextElement();
                    Certificate certificate = keyStore.getCertificate(string2);
                    if (!(certificate instanceof X509Certificate)) continue;
                    X509Certificate x509Certificate = (X509Certificate)certificate;
                    if (x509Certificate.getNotAfter().before(date)) {
                        Util_Logger.warning(logger, string + " certificate [" + string2 + "] valid from " + Util.dateToStr(x509Certificate.getNotBefore(), "dd/MM/yyyy") + " to " + Util.dateToStr(x509Certificate.getNotAfter(), "dd/MM/yyyy"));
                    } else {
                        Util_Logger.info(logger, string + " certificate [" + string2 + "] valid from " + Util.dateToStr(x509Certificate.getNotBefore(), "dd/MM/yyyy") + " to " + Util.dateToStr(x509Certificate.getNotAfter(), "dd/MM/yyyy"));
                    }
                    bl = true;
                }
                if (!bl) {
                    Util_Logger.info(logger, "No certificates found");
                }
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Error listing certificates from keystore [" + this.itsCertStoreConfig.KeyStoreFile + "]: " + exception.getMessage(), exception);
            }
        }
    }

    public void addTrustedCertificate(String string, byte[] byArray) throws ApplicationException {
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);){
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
            this.addTrustedCertificate(string, x509Certificate);
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error adding x509 certificate PEM with alias [" + string + "] to keystore [" + this.itsCertStoreConfig.KeyStoreFile + "]: " + exception.getMessage(), exception);
        }
    }

    public void addTrustedCertificate(String string, String string2) throws ApplicationException {
        this.addTrustedCertificate(string, string2.getBytes());
    }

    public void addTrustedCertificate(String string, X509Certificate x509Certificate) throws ApplicationException {
        try {
            if (this.itsCertStoreConfig == null) {
                throw new Exception("Missing certificate store configuration");
            }
            KeyStore keyStore = null;
            if (Files.exists(Paths.get(this.itsCertStoreConfig.KeyStoreFile, new String[0]), new LinkOption[0])) {
                keyStore = this.loadKeystore();
            } else {
                Util_Logger.info(logger, "Creating new keystore at [" + this.itsCertStoreConfig.KeyStoreFile + "]");
                keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(null, this.itsCertStoreConfig.StorePassword.toCharArray());
            }
            if (string != null) {
                if (keyStore.containsAlias(string)) {
                    keyStore.deleteEntry(string);
                }
                Util_Logger.info(logger, "Adding X509 certificate with alias [" + string + "] to keystore file [" + this.itsCertStoreConfig.KeyStoreFile + "]");
                keyStore.setCertificateEntry(string, x509Certificate);
            }
            this.saveKeystore(keyStore);
        }
        catch (Exception exception) {
            String string2 = this.itsCertStoreConfig != null ? "] from keystore [" + this.itsCertStoreConfig.KeyStoreFile : "";
            Util_Logger.error(logger, "Error adding certificate with alias [" + string + string2 + "]: " + exception.getMessage(), exception);
        }
    }

    public void importCertificateSignRequestReply(String string, String string2) throws ApplicationException {
        try {
            KeyStore keyStore = null;
            if (!Files.exists(Paths.get(this.itsCertStoreConfig.KeyStoreFile, new String[0]), new LinkOption[0])) {
                throw new IllegalArgumentException("Keytore does not exist");
            }
            keyStore = this.loadKeystore();
            if (Util.isBlank(string)) {
                throw new IllegalArgumentException("Missing Alias arguement");
            }
            if (!Files.exists(Paths.get(string2, new String[0]), new LinkOption[0])) {
                throw new IllegalArgumentException("Certificate file [" + string2 + "] does not exist");
            }
            if (!keyStore.containsAlias(string)) {
                throw new IllegalArgumentException("Alias does not exist");
            }
            byte[] byArray = Files.readAllBytes(Paths.get(string2, new String[0]));
            try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);){
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                Certificate[] certificateArray = new X509Certificate[]{x509Certificate};
                Key key = keyStore.getKey(string, this.itsCertStoreConfig.StorePassword.toCharArray());
                keyStore.deleteEntry(string);
                keyStore.setKeyEntry(string, key, this.itsCertStoreConfig.KeyPassword.toCharArray(), certificateArray);
            }
            this.saveKeystore(keyStore);
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error adding certificate to chain with alias [" + string + "] to keystore [" + this.itsCertStoreConfig.KeyStoreFile + "]: " + exception.getMessage(), exception);
        }
    }

    public void addCertificatesToChain(String string, List<String> list) throws ApplicationException {
        try {
            Object object;
            if (this.itsCertStoreConfig == null) {
                throw new Exception("Missing certificate store configuration");
            }
            KeyStore keyStore = null;
            if (!Files.exists(Paths.get(this.itsCertStoreConfig.KeyStoreFile, new String[0]), new LinkOption[0])) {
                throw new IllegalArgumentException("Keytore does not exist");
            }
            keyStore = this.loadKeystore();
            if (Util.isBlank(string)) {
                throw new IllegalArgumentException("Missing Alias arguement");
            }
            for (String object22 : list) {
                if (Files.exists(Paths.get(object22, new String[0]), new LinkOption[0])) continue;
                throw new IllegalArgumentException("Certificate file [" + object22 + "] does not exist");
            }
            if (!keyStore.containsAlias(string)) {
                throw new IllegalArgumentException("Alias does not exist");
            }
            ArrayList arrayList = new ArrayList();
            for (String string2 : list) {
                object = Files.readAllBytes(Paths.get(string2, new String[0]));
                try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);){
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    Certificate certificate = certificateFactory.generateCertificate(byteArrayInputStream);
                    arrayList.add(certificate);
                }
            }
            Util_Logger.info(logger, "Adding [" + arrayList.size() + "] certificates to chain [" + string + "]");
            Key key = keyStore.getKey(string, this.itsCertStoreConfig.StorePassword.toCharArray());
            Certificate[] certificateArray = keyStore.getCertificateChain(string);
            object = new ArrayList();
            object.addAll(Arrays.asList(certificateArray));
            object.addAll(arrayList);
            keyStore.setKeyEntry(string, key, this.itsCertStoreConfig.KeyPassword.toCharArray(), object.toArray(new Certificate[0]));
            this.saveKeystore(keyStore);
        }
        catch (Exception exception) {
            String string2 = this.itsCertStoreConfig != null ? "] from keystore [" + this.itsCertStoreConfig.KeyStoreFile : "";
            Util_Logger.error(logger, "Error adding certificate to chain with alias [" + string + string2 + "]: " + exception.getMessage(), exception);
        }
    }

    public X509Certificate getCertificate(String string) throws ApplicationException {
        X509Certificate x509Certificate = null;
        try {
            KeyStore keyStore = this.loadKeystore();
            if (string != null && keyStore.containsAlias(string)) {
                x509Certificate = (X509Certificate)keyStore.getCertificate(string);
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error getting certificate with alias [" + string + "] from keystore [" + this.itsCertStoreConfig.KeyStoreFile + "]: " + exception.getMessage(), exception);
        }
        return x509Certificate;
    }

    public void removeCertificate(String string) throws ApplicationException {
        try {
            if (this.itsCertStoreConfig == null) {
                throw new Exception("Missing certificate store configuration");
            }
            if (Files.exists(Paths.get(this.itsCertStoreConfig.KeyStoreFile, new String[0]), new LinkOption[0])) {
                KeyStore keyStore = this.loadKeystore();
                if (string != null) {
                    if (keyStore.containsAlias(string)) {
                        keyStore.deleteEntry(string);
                        Util_Logger.info(logger, "Certificate with alias [" + string + "] removed from keystore file [" + this.itsCertStoreConfig.KeyStoreFile + "]");
                        this.saveKeystore(keyStore);
                    } else {
                        Util_Logger.warning(logger, "Certificate with alias [" + string + "] not found in keystore file [" + this.itsCertStoreConfig.KeyStoreFile + "]");
                    }
                }
            }
        }
        catch (Exception exception) {
            String string2 = this.itsCertStoreConfig != null ? "] from keystore [" + this.itsCertStoreConfig.KeyStoreFile : "";
            Util_Logger.error(logger, "Error removing certificate with alias [" + string + string2 + "]: " + exception.getMessage(), exception);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void importCertificate(String string, String string2) throws ApplicationException {
        try {
            if (this.itsCertStoreConfig == null) {
                throw new Exception("Missing certificate store configuration");
            }
            if (!Files.exists(Paths.get(string, new String[0]), new LinkOption[0])) throw new IllegalArgumentException("Certificate file not found");
            KeyStore keyStore = this.loadKeystore();
            if (string2 == null) throw new IllegalArgumentException("Missing alias parameter");
            if (keyStore.containsAlias(string2)) {
                throw new IllegalArgumentException("Alias already exists");
            }
            byte[] byArray = Files.readAllBytes(Paths.get(string, new String[0]));
            this.addTrustedCertificate(string2, byArray);
            return;
        }
        catch (Exception exception) {
            String string3 = this.itsCertStoreConfig != null ? "] from keystore [" + this.itsCertStoreConfig.KeyStoreFile : "";
            Util_Logger.error(logger, "Error importing certificate with alias [" + string2 + string3 + "]: " + exception.getMessage(), exception);
        }
    }

    public void exportCertificate(String string, String string2) throws ApplicationException {
        try {
            if (this.itsCertStoreConfig == null) {
                throw new Exception("Missing certificate store configuration");
            }
            KeyStore keyStore = this.loadKeystore();
            if (string != null) {
                if (!keyStore.containsAlias(string)) {
                    throw new IllegalArgumentException("Alias does not exists");
                }
            } else {
                throw new IllegalArgumentException("Missing alias parameter");
            }
            X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
            String string3 = this.extractCertificateToPEM(x509Certificate);
            Files.write(Paths.get(string2, new String[0]), string3.getBytes(), new OpenOption[0]);
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error exporting certificate with alias [" + string + "] from keystore [" + this.itsCertStoreConfig.KeyStoreFile + "]: " + exception.getMessage(), exception);
        }
    }

    public void createCertificateSigningRequest(String string, String string2) throws ApplicationException {
        try {
            if (this.itsCertStoreConfig == null) {
                throw new Exception("Missing certificate store configuration");
            }
            boolean bl = System.getProperty("os.name").toLowerCase().startsWith("windows");
            String string3 = bl ? "cmd" : "/bin/bash";
            String string4 = bl ? "/c" : "-c";
            String[] stringArray = new String[]{string3, string4, "keytool", "-certreq", "-keyalg", "RSA", "-alias", string, "-file", string2, "-keystore", this.itsCertStoreConfig.KeyStoreFile, "-storetype", this.itsCertStoreConfig.KeyStoreType, "-storepass", this.itsCertStoreConfig.StorePassword, "-keypass", this.itsCertStoreConfig.KeyPassword};
            ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
            processBuilder.directory(new File(".")).redirectErrorStream(true);
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            StringBuilder stringBuilder = new StringBuilder();
            Scanner scanner = new Scanner(process.getInputStream());
            while (scanner.hasNextLine()) {
                String string5 = scanner.nextLine();
                stringBuilder.append(string5);
                stringBuilder.append("\n");
            }
            process.waitFor();
            if (process.exitValue() != 0) {
                throw new Exception(stringBuilder.toString());
            }
            Util_Logger.info(logger, "Created certificate signing request: " + stringBuilder.toString());
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error Creating certificate signign request: " + exception.getMessage(), exception);
        }
    }

    public boolean serverListening(String string, int n) {
        boolean bl;
        Socket socket = new Socket(string, n);
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                return false;
            }
        }
        socket.close();
        return bl;
    }

    private CertificateDetail getCertificateDetail(X509Certificate x509Certificate) throws Exception {
        String string;
        CertificateDetail certificateDetail = new CertificateDetail();
        certificateDetail.Cert = x509Certificate;
        certificateDetail.SerialNumber = x509Certificate.getSerialNumber().toString();
        Csv csv = new Csv();
        String[] stringArray = csv.parse(x509Certificate.getIssuerX500Principal().getName());
        if (stringArray != null) {
            for (String list : stringArray) {
                string = list.trim().toUpperCase();
                if (!string.startsWith("CN")) continue;
                String[] stringArray2 = Util.getColumns(string, '=');
                if (stringArray2.length != 2) break;
                certificateDetail.CommonName = stringArray2[1].trim();
                break;
            }
        }
        certificateDetail.ValidFrom = x509Certificate.getNotBefore();
        certificateDetail.ValidTo = x509Certificate.getNotAfter();
        certificateDetail.Algorithm = x509Certificate.getSigAlgName();
        certificateDetail.Issuer = x509Certificate.getIssuerX500Principal().toString();
        certificateDetail.PublicKey = this.extractCertificateToPEM(x509Certificate);
        certificateDetail.Thumbprint = this.getThumbprint(x509Certificate);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = "";
        for (List<?> list : x509Certificate.getSubjectAlternativeNames()) {
            if (list.size() < 2 || !((string = list.get(1)) instanceof String)) continue;
            switch ((Integer)list.get(0)) {
                case 2: {
                    stringBuilder.append(string2);
                    stringBuilder.append("IP:");
                    stringBuilder.append((Object)string);
                    string2 = "; ";
                    break;
                }
                case 7: {
                    stringBuilder.append(string2);
                    stringBuilder.append("DNS:");
                    stringBuilder.append((Object)string);
                    string2 = "; ";
                    break;
                }
            }
        }
        certificateDetail.SubjectAlternativeNames = stringBuilder.toString();
        return certificateDetail;
    }

    public void identifyTrustedCertificates(List<CertificateDetail> list) throws Exception {
        if (this.itsCertStoreConfig != null) {
            KeyStore keyStore = this.loadKeystore();
            for (CertificateDetail certificateDetail : list) {
                Enumeration<String> enumeration = keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    X509Certificate x509Certificate;
                    String string = enumeration.nextElement();
                    Certificate certificate = keyStore.getCertificate(string);
                    if (!(certificate instanceof X509Certificate) || !(x509Certificate = (X509Certificate)certificate).getSerialNumber().toString().equalsIgnoreCase(certificateDetail.SerialNumber)) continue;
                    certificateDetail.IsTrusted = 1;
                }
            }
        }
    }

    public WebServerConnectivity fetchCertificateFromServer(String string, int n) throws ApplicationException {
        WebServerConnectivity webServerConnectivity;
        block12: {
            webServerConnectivity = new WebServerConnectivity();
            webServerConnectivity.Certificates = new ArrayList<CertificateDetail>();
            try {
                webServerConnectivity.PortIsActive = this.serverListening(string, n);
                if (!webServerConnectivity.PortIsActive) break block12;
                TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }
                }};
                String string2 = "TLS";
                if (this.itsCertStoreConfig != null) {
                    string2 = this.itsCertStoreConfig.Protocol;
                }
                SSLContext sSLContext = SSLContext.getInstance(string2);
                sSLContext.init(null, trustManagerArray, new SecureRandom());
                SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
                try (SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(string, n);){
                    Certificate[] certificateArray;
                    sSLSocket.setSoTimeout(2000);
                    sSLSocket.startHandshake();
                    SSLSession sSLSession = sSLSocket.getSession();
                    for (Certificate certificate : certificateArray = sSLSession.getPeerCertificates()) {
                        if (!(certificate instanceof X509Certificate)) continue;
                        X509Certificate x509Certificate = (X509Certificate)certificate;
                        CertificateDetail certificateDetail = this.getCertificateDetail(x509Certificate);
                        webServerConnectivity.Certificates.add(certificateDetail);
                    }
                }
                this.identifyTrustedCertificates(webServerConnectivity.Certificates);
            }
            catch (SSLProtocolException sSLProtocolException) {
            }
            catch (SocketTimeoutException socketTimeoutException) {
            }
            catch (Exception exception) {
                Util_Logger.error(logger, "Error fetching certificates from host [" + string + ":" + n + "]: " + exception.getMessage(), exception);
            }
        }
        return webServerConnectivity;
    }

    public static CertificateStoreConfig loadConfigFromProperties(Properties properties, String string) {
        CertificateStoreConfig certificateStoreConfig = new CertificateStoreConfig();
        Object object = Util.isBlank(string) ? "" : string + "_";
        certificateStoreConfig.KeyStoreFile = Util.getProperty(properties, (String)object + "https_keystore_file", null);
        certificateStoreConfig.KeyStoreType = Util.getProperty(properties, (String)object + "https_keystore_type", null);
        certificateStoreConfig.StorePassword = Util.getProperty(properties, (String)object + "https_store_password", null);
        certificateStoreConfig.KeyPassword = Util.getProperty(properties, (String)object + "https_key_password", null);
        certificateStoreConfig.Protocol = Util.getProperty(properties, (String)object + "https_protocol", null);
        certificateStoreConfig.setDefaultValues();
        if (Util.isBlank(certificateStoreConfig.KeyStoreFile)) {
            certificateStoreConfig = null;
        }
        return certificateStoreConfig;
    }

    private SSLContext getSslContext(KeyStore keyStore) throws Exception {
        if (Util.isBlank(this.itsCertStoreConfig.KeyPassword)) {
            throw new Exception("Key password must be defined for HTTPS protocol");
        }
        char[] cArray = this.itsCertStoreConfig.KeyPassword.toCharArray();
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        keyManagerFactory.init(keyStore, cArray);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
        trustManagerFactory.init(keyStore);
        SSLContext sSLContext = SSLContext.getInstance(Util.isBlank(this.itsCertStoreConfig.Protocol, "TLS"));
        sSLContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        return sSLContext;
    }

    public SSLContext getSslContext() throws Exception {
        if (this.itsSSLContext == null) {
            KeyStore keyStore = this.loadKeystore();
            this.itsSSLContext = this.getSslContext(keyStore);
        }
        return this.itsSSLContext;
    }

    protected String extractCertificateToPEM(X509Certificate x509Certificate) throws CertificateEncodingException {
        String string = System.getProperty("line.separator");
        Base64.Encoder encoder = Base64.getMimeEncoder(64, string.getBytes());
        byte[] byArray = x509Certificate.getEncoded();
        String string2 = new String(encoder.encode(byArray));
        String string3 = "-----BEGIN CERTIFICATE-----" + string + string2 + string + "-----END CERTIFICATE-----";
        return string3;
    }

    public String getThumbprint(X509Certificate x509Certificate) throws NoSuchAlgorithmException, CertificateEncodingException {
        return DigestUtils.sha1Hex(x509Certificate.getEncoded());
    }
}

