/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Cryptography;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.Authentication.KeyListenerInt;
import au.com.aemo.Common.Authentication.KeyManager;
import au.com.aemo.Common.Authentication.KeyTypeEnum;
import au.com.aemo.Common.Cryptography.CryptProviderFactory;
import au.com.aemo.Common.Cryptography.CryptProviderInt;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Crypt
implements KeyListenerInt {
    private static Logger logger = LoggerFactory.getLogger(Crypt.class);
    private CryptProviderInt secObject;
    private String itsSeed;

    public static Crypt getInstance() {
        return SingletonHolder.instance;
    }

    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"}, justification="Required for docker")
    private Crypt() {
        try {
            KeyManager.getInstance().addListener(this);
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error initialising Crypt provider: " + exception.getMessage(), exception);
        }
    }

    @Override
    public KeyTypeEnum getKeyType() {
        return KeyTypeEnum.HASH;
    }

    @Override
    public void updatedKey(String string, Date date) throws ApplicationException {
        this.itsSeed = string;
        if (!Util.isBlank(this.itsSeed)) {
            this.secObject = CryptProviderFactory.getProvider(this.itsSeed);
        } else {
            Util_Logger.error(logger, "Error initialising Crypt provider, unable to retrieve encryption key");
        }
    }

    public void setSeed(String string) {
        this.secObject = CryptProviderFactory.getProvider(string);
    }

    public String getSeed() {
        return this.itsSeed;
    }

    public String encrypt(String string) throws ApplicationException {
        String string2 = null;
        try {
            string2 = this.secObject.encrypt(string);
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error processing encrypt: " + exception.getMessage(), exception);
        }
        return string2;
    }

    public String decrypt(String string) throws ApplicationException {
        String string2 = null;
        try {
            string2 = this.secObject.decrypt(string);
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error processing decrypt: " + exception.getMessage(), exception);
        }
        return string2;
    }

    public static void main(String[] stringArray) throws ApplicationException {
        try {
            KeyManager.getInstance().loadKeyConfiguration();
            Crypt crypt = Crypt.getInstance();
            System.out.println("Passwd - encrypting - " + stringArray[0]);
            String string = crypt.encrypt(stringArray[0]);
            System.out.println("Returns - " + string);
            System.out.println("Decrypting - " + crypt.decrypt(string));
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error processing encrypt: " + exception.getMessage(), exception);
        }
    }

    private static class SingletonHolder {
        private static Crypt instance = new Crypt();

        private SingletonHolder() {
        }
    }
}

