/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Database;

import au.com.aemo.Common.Application.ConfigurationValueResolver;
import au.com.aemo.Common.Application.XProperties;
import au.com.aemo.Common.Cryptography.Crypt;
import au.com.aemo.Common.Database.DbManager;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppDatabaseScriptRunner {
    private static Logger logger = LoggerFactory.getLogger(AppDatabaseScriptRunner.class);

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        Object object;
        XProperties xProperties;
        Crypt crypt;
        String string;
        Boolean bl;
        boolean bl2;
        boolean bl3;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        block40: {
            Options options = new Options();
            options.addRequiredOption("u", "user", true, "The database user");
            options.addRequiredOption("p", "password", true, "The encrypted database password");
            options.addRequiredOption("c", "connection", true, "The JDBC connection URL");
            options.addRequiredOption("s", "script", true, "The SQL script to run");
            options.addRequiredOption("t", "terminator", true, "The terminator for a statement in the script");
            options.addOption("v", "variables", true, "The file containing variables to merge into the query");
            options.addOption("i", "ignore-pk-violations", false, "Flag set to ignore primary key violations");
            options.addOption("d", "debug", false, "Flag set to debug mode");
            options.addOption("n", "not-exists", true, "The database SQL check query. If the query returns no rows, the script is run");
            options.addOption("a", "autocommit", true, "Flag set to autocommit mode");
            DefaultParser defaultParser = new DefaultParser();
            CommandLine commandLine = null;
            try {
                commandLine = defaultParser.parse(options, stringArray);
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                HelpFormatter helpFormatter = new HelpFormatter();
                helpFormatter.printHelp("AppDatabaseScriptRunner", options);
                System.exit(1);
            }
            string6 = commandLine.getOptionValue("user");
            string5 = commandLine.getOptionValue("password");
            string4 = commandLine.getOptionValue("connection");
            string3 = commandLine.getOptionValue("script", null);
            string2 = commandLine.getOptionValue("terminator", null);
            String string7 = commandLine.getOptionValue("variables", null);
            bl3 = commandLine.hasOption("ignore-pk-violations");
            bl2 = commandLine.hasOption("debug");
            bl = null;
            if (commandLine.hasOption("autocommit")) {
                bl = commandLine.getOptionValue("autocommit", "false").equalsIgnoreCase("true");
            }
            string = commandLine.getOptionValue("not-exists", null);
            Util_Logger.info(logger, "Starting AppDatabaseScriptRunner with script " + string3);
            crypt = Crypt.getInstance();
            xProperties = new XProperties();
            try {
                if (Util.isBlank(string7)) break block40;
                object = new FileInputStream(new File(string7));
                try {
                    xProperties.load((InputStream)object);
                }
                finally {
                    ((FileInputStream)object).close();
                }
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Error preparing variables : " + exception.getMessage(), exception);
                System.exit(1);
            }
        }
        object = null;
        if (!xProperties.isEmpty()) {
            object = new ConfigurationValueResolver(){

                @Override
                public String resolveExternalVariable(String string, int n) {
                    return xProperties.getProperty(string);
                }
            };
            string4 = ((ConfigurationValueResolver)object).resolveValue(string4, false);
            string6 = ((ConfigurationValueResolver)object).resolveValue(string6, false);
            String string8 = ((ConfigurationValueResolver)object).resolveValue(string5, false);
        }
        try {
            void var5_9;
            String string9 = crypt.decrypt((String)var5_9);
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error decrypting database password : " + exception.getMessage(), exception);
            System.exit(1);
        }
        Util_Logger.info(logger, "Connecting to " + string4 + " with user " + string6);
        try {
            void var5_11;
            try (Connection connection = DriverManager.getConnection(string4, string6, (String)var5_11);){
                boolean bl4;
                block41: {
                    bl4 = true;
                    if (!Util.isBlank(string)) {
                        if (string.trim().toLowerCase().startsWith("select ")) {
                            String string10 = string;
                            if (object != null) {
                                if (bl2) {
                                    System.out.println(string10);
                                }
                                string10 = ((ConfigurationValueResolver)object).resolveValue(string, false);
                                if (bl2) {
                                    System.out.println(string10);
                                }
                            }
                            try (Statement statement = connection.createStatement();
                                 ResultSet resultSet = statement.executeQuery(string10);){
                                if (resultSet.next()) {
                                    bl4 = false;
                                }
                                break block41;
                            }
                        }
                        Util_Logger.warning(logger, "Invalid check query '" + string + "'. Only select statements are supported");
                    }
                }
                if (bl4) {
                    Util_Logger.info(logger, "Running database script " + string3);
                    DbManager.runScript(connection, string3, string2, bl, bl3, (ConfigurationValueResolver)object, bl2);
                    Util_Logger.info(logger, "Successfully run database script " + string3);
                    return;
                }
                Util_Logger.info(logger, "Detected check query returned rows, skipping database script");
                return;
            }
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error running database script " + string3 + " : " + exception.getMessage(), exception);
            System.exit(1);
        }
    }
}

