/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Database;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.Database.DbHandler;
import au.com.aemo.Common.Logging.Util_Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbConnectionPoolFactory
implements PooledObjectFactory<Connection> {
    private static Logger logger = LoggerFactory.getLogger(DbConnectionPoolFactory.class);
    private String itsApplicationId;
    private DbHandler itsDb = null;
    private String itsAppName;
    private String itsAppVersion;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Private constructor")
    public DbConnectionPoolFactory(DbHandler dbHandler, String string, String string2) throws ApplicationException {
        this.itsDb = dbHandler;
        this.itsAppName = string;
        this.itsAppVersion = string2;
        this.itsApplicationId = "?";
    }

    public synchronized PooledObject<Connection> makeObject() throws Exception {
        Connection connection = this.itsDb.getConnection();
        Util_Logger.info(logger, "Opened connection " + connection.toString());
        return new DefaultPooledObject((Object)connection);
    }

    public boolean validateObject(PooledObject<Connection> pooledObject) {
        boolean bl = false;
        Connection connection = (Connection)pooledObject.getObject();
        if (connection == null) {
            return false;
        }
        bl = this.itsDb.isValid(connection);
        Util_Logger.debug(logger, "Validated database session [" + connection.toString() + "], status=" + bl);
        return bl;
    }

    public void activateObject(PooledObject<Connection> pooledObject) {
        try {
            Connection connection = (Connection)pooledObject.getObject();
            Util_Logger.debug(logger, "Activating database session [" + connection.toString() + "]");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void passivateObject(PooledObject<Connection> pooledObject) throws Exception {
        try {
            Connection connection = (Connection)pooledObject.getObject();
            if (connection != null) {
                Util_Logger.debug(logger, "Passivating database session [" + connection.toString() + "]");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void destroyObject(PooledObject<Connection> pooledObject) throws Exception {
        block6: {
            try {
                Connection connection = (Connection)pooledObject.getObject();
                if (connection == null) break block6;
                Util_Logger.debug(logger, "Destroying database session [" + connection.toString() + "]");
                try {
                    connection.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

