/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Database;

import au.com.aemo.Common.Application.AppConfiguration;
import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.Application.ConfigurationValueResolver;
import au.com.aemo.Common.CSV.CsvWriter;
import au.com.aemo.Common.Database.DatabaseConfig;
import au.com.aemo.Common.Database.DbConnectionPool;
import au.com.aemo.Common.Database.DbHandler;
import au.com.aemo.Common.Database.DbHandlerMetadata;
import au.com.aemo.Common.Database.DbHandlerMetadataManager;
import au.com.aemo.Common.Database.DbPreparedStatementParam;
import au.com.aemo.Common.Database.DbQueryResultsReader;
import au.com.aemo.Common.Database.DbQuerySetParams;
import au.com.aemo.Common.Database.DbScriptRunner;
import au.com.aemo.Common.Database.DbTableMapper;
import au.com.aemo.Common.Database.DbTableMapperColumn;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileReader;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbManager {
    private static Logger logger = LoggerFactory.getLogger(DbManager.class);
    private static DbConnectionPool myBroker = null;
    private static DbHandler itsHandler = null;

    public static DatabaseConfig loadConfigFromProperties(Properties properties) throws ApplicationException {
        DatabaseConfig databaseConfig = new DatabaseConfig();
        databaseConfig.User = Util.getProperty(properties, "db_user", null);
        databaseConfig.Password = Util.getProperty(properties, "db_password", null);
        databaseConfig.Driver = Util.getProperty(properties, "db_driver");
        databaseConfig.URL = Util.getProperty(properties, "db_url");
        databaseConfig.DefaultSchema = Util.getProperty(properties, "db_default_schema", null);
        databaseConfig.DbHandler = Util.getProperty(properties, "db_handler");
        databaseConfig.DbDateFormat = Util.getProperty(properties, "db_date_format");
        databaseConfig.DbTimestampFormat = Util.getProperty(properties, "db_timestamp_format", databaseConfig.DbDateFormat);
        databaseConfig.JavaDateFormat = Util.getProperty(properties, "java_date_format");
        databaseConfig.JavaTimestampFormat = Util.getProperty(properties, "java_timestamp_format");
        databaseConfig.InsertMode = Util.getProperty(properties, "db_insert_mode", "safe");
        databaseConfig.DbProps = Util.getProperty(properties, "db_properties", null);
        databaseConfig.DbConnInitSQL = Util.getProperty(properties, "db_conn_init_sql", null);
        databaseConfig.DbTablespacesToReport = Util.getColumns(Util.getProperty(properties, "db_tablespaces_to_report", null), ',');
        databaseConfig.PasswordEncrypted = Util.getProperty(properties, "db_password_encrypted", "true").equalsIgnoreCase("true");
        databaseConfig.DbPoolMaxWaitForConnectionSecs = Integer.parseInt(Util.getProperty(properties, "db_pool_connection_max_wait", "60"));
        databaseConfig.DbPoolMinConnections = Integer.parseInt(Util.getProperty(properties, "db_pool_min_connections", "3"));
        databaseConfig.DbPoolMaxConnections = Integer.parseInt(Util.getProperty(properties, "db_pool_max_connections", "15"));
        databaseConfig.DbPoolTimeBetweenEvictionRunsSecs = Integer.parseInt(Util.getProperty(properties, "db_pool_eviction_cycle", "120"));
        databaseConfig.PrimaryKeySQLErrorCode = Util.getProperty(properties, "db_primary_key_sql_error_code", null);
        return databaseConfig;
    }

    public static void initDbPool(AppConfiguration appConfiguration) throws ApplicationException {
        try {
            if (myBroker == null) {
                myBroker = new DbConnectionPool(appConfiguration.Database, appConfiguration.AppName, appConfiguration.AppVersion);
                itsHandler = myBroker.getDbHandler();
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Failed to initiate DB pool : " + exception.getMessage(), exception);
        }
    }

    public static void freeDbConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            myBroker.returnConnection(connection);
        }
    }

    @SuppressFBWarnings(value={"DE_MIGHT_IGNORE"}, justification="Do not need to report exception closing Statement when returning database connection")
    public static void freeDbConnection(Connection connection, Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        DbManager.freeDbConnection(connection);
    }

    @SuppressFBWarnings(value={"DE_MIGHT_IGNORE"}, justification="Do not need to report exception closing ResultSet when returning database connection")
    public static void freeDbConnection(Connection connection, Statement statement, ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        DbManager.freeDbConnection(connection, statement);
    }

    public static Connection getDbConnection() throws ApplicationException {
        Connection connection = null;
        try {
            connection = myBroker.getConnection();
            connection.setAutoCommit(false);
            connection.rollback();
        }
        catch (SQLException sQLException) {
            Util_Logger.error(logger, "Failed to get DB connection : " + sQLException.getMessage(), sQLException);
        }
        return connection;
    }

    public static void closeDbPool() {
        try {
            if (myBroker != null) {
                myBroker.closePool();
                Util_Logger.info(logger, "Closed db pool");
            }
        }
        catch (Exception exception) {
            Util_Logger.warning(logger, "Detected problem closing database connection pool: " + exception.getMessage(), exception);
        }
    }

    public static DbHandler getDbHandler() {
        return itsHandler;
    }

    public static void setDbHandler(DbHandler dbHandler) {
        itsHandler = dbHandler;
    }

    private static void setPreparedStatementValue(PreparedStatement preparedStatement, DbTableMapperColumn dbTableMapperColumn, int n, DbHandler dbHandler, Object object, int n2) throws Exception {
        String string;
        Object object2 = dbTableMapperColumn.objectProperty.get(object);
        String string2 = string = object2 == null ? null : object2.toString();
        if (object2 instanceof Date) {
            string = Util.dateToStr((Date)object2, dbHandler.getDateFieldFormat(dbTableMapperColumn.Definition));
        } else if (object2 instanceof Boolean) {
            string = Integer.toString(Util.booleanToInt(Boolean.valueOf(string)));
        }
        dbHandler.setSqlPreparedStatementFormat(preparedStatement, n, string, n2);
    }

    public static <T> void insertObject(Connection connection, Class<T> clazz, String string, String string2, T t) throws ApplicationException {
        DbManager.insertObjects(connection, clazz, string, string2, new ArrayList<Object>(Arrays.asList(t)));
    }

    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="Prepared statement uses bind variables. Called by trusted code and no SQL injection risk")
    public static <T> void insertObjects(Connection connection, Class<T> clazz, String string, String string2, List<T> list) throws ApplicationException {
        Object object;
        DbHandlerMetadataManager dbHandlerMetadataManager = DbHandlerMetadataManager.getInstance();
        DbHandler dbHandler = DbManager.getDbHandler();
        DbHandlerMetadata dbHandlerMetadata = dbHandlerMetadataManager.getMetadata(connection, dbHandler, string, string2);
        DbTableMapper dbTableMapper = dbHandlerMetadataManager.getMapper(connection, clazz, string, string2);
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n = 1;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("insert into ");
        stringBuilder.append(dbHandler.getTableReference(string, string2));
        stringBuilder.append(" (");
        String string3 = "";
        for (DbTableMapperColumn iterator : dbTableMapper.Columns.values()) {
            if (Modifier.isTransient(iterator.objectProperty.getModifiers())) continue;
            stringBuilder.append(string3);
            stringBuilder.append(iterator.ColumnName);
            string3 = ",";
        }
        if (dbHandlerMetadata.getPkList().size() > 0) {
            stringBuilder.append(") select ");
        } else {
            stringBuilder.append(") values (");
        }
        string3 = "";
        for (DbTableMapperColumn dbTableMapperColumn : dbTableMapper.Columns.values()) {
            if (Modifier.isTransient(dbTableMapperColumn.objectProperty.getModifiers())) continue;
            stringBuilder.append(string3);
            DbPreparedStatementParam dbPreparedStatementParam = dbHandler.getSqlPreparedStatementFormat(dbTableMapperColumn.Definition);
            stringBuilder.append(dbPreparedStatementParam.getSQL());
            hashMap.put(n, dbPreparedStatementParam.getParamType());
            ++n;
            string3 = ",";
        }
        if (dbHandlerMetadata.getPkList().size() <= 0) {
            stringBuilder.append(")");
        } else {
            stringBuilder.append(" ");
            if (dbHandler.getPreferExistsStatement()) {
                stringBuilder.append(dbHandler.getNoTable());
                stringBuilder.append(" where not exists (");
                stringBuilder.append("select 1 ");
            }
            stringBuilder.append(" from ");
            stringBuilder.append(string2);
            stringBuilder.append(" where ");
            object = "";
            for (DbTableMapperColumn dbTableMapperColumn : dbTableMapper.Columns.values()) {
                if (!dbTableMapperColumn.Definition.getIsPrimaryKey()) continue;
                stringBuilder.append((String)object);
                stringBuilder.append(dbTableMapperColumn.ColumnName);
                stringBuilder.append(" = ");
                DbPreparedStatementParam dbPreparedStatementParam = dbHandler.getSqlPreparedStatementFormat(dbTableMapperColumn.Definition);
                stringBuilder.append(dbPreparedStatementParam.getSQL());
                hashMap.put(n, dbPreparedStatementParam.getParamType());
                ++n;
                object = " and ";
            }
            if (dbHandler.getPreferExistsStatement()) {
                stringBuilder.append(")");
            } else {
                stringBuilder.append(" having count(1) = 0");
            }
        }
        try {
            object = connection.prepareStatement(stringBuilder.toString());
            try {
                for (T t : list) {
                    n = 1;
                    for (DbTableMapperColumn dbTableMapperColumn : dbTableMapper.Columns.values()) {
                        if (Modifier.isTransient(dbTableMapperColumn.objectProperty.getModifiers())) continue;
                        DbManager.setPreparedStatementValue((PreparedStatement)object, dbTableMapperColumn, n, dbHandler, t, (Integer)hashMap.get(n));
                        ++n;
                    }
                    for (DbTableMapperColumn dbTableMapperColumn : dbTableMapper.Columns.values()) {
                        if (!dbTableMapperColumn.Definition.getIsPrimaryKey()) continue;
                        DbManager.setPreparedStatementValue((PreparedStatement)object, dbTableMapperColumn, n, dbHandler, t, (Integer)hashMap.get(n));
                        ++n;
                    }
                    object.addBatch();
                }
                object.executeBatch();
            }
            finally {
                if (object != null) {
                    object.close();
                }
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error inserting records into database: " + exception.getMessage(), exception);
        }
    }

    public static <T> int updateObject(Connection connection, Class<T> clazz, String string, String string2, T t) throws ApplicationException {
        int[] nArray = DbManager.updateObjects(connection, clazz, string, string2, new ArrayList<Object>(Arrays.asList(t)));
        return nArray[0];
    }

    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="Prepared statement uses bind variables. Called by trusted code and no SQL injection risk")
    public static <T> int[] updateObjects(Connection connection, Class<T> clazz, String string, String string2, List<T> list) throws ApplicationException {
        Object object2;
        int[] nArray = null;
        DbHandlerMetadataManager dbHandlerMetadataManager = DbHandlerMetadataManager.getInstance();
        DbHandler dbHandler = DbManager.getDbHandler();
        DbHandlerMetadata dbHandlerMetadata = dbHandlerMetadataManager.getMetadata(connection, dbHandler, string, string2);
        DbTableMapper dbTableMapper = dbHandlerMetadataManager.getMapper(connection, clazz, string, string2);
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n = 1;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("update ");
        stringBuilder.append(dbHandler.getTableReference(string, string2));
        stringBuilder.append(" set ");
        String string3 = "";
        for (DbTableMapperColumn object2 : dbTableMapper.Columns.values()) {
            if (Modifier.isTransient(object2.objectProperty.getModifiers())) continue;
            stringBuilder.append(string3);
            stringBuilder.append(object2.ColumnName);
            stringBuilder.append(" = ");
            object2 = dbHandler.getSqlPreparedStatementFormat(object2.Definition);
            stringBuilder.append(((DbPreparedStatementParam)object2).getSQL());
            hashMap.put(n, ((DbPreparedStatementParam)object2).getParamType());
            ++n;
            string3 = ",";
        }
        if (dbHandlerMetadata.getPkList().size() > 0) {
            stringBuilder.append(" where ");
            string3 = "";
            for (String string4 : dbHandlerMetadata.getPkList()) {
                stringBuilder.append(string3);
                stringBuilder.append(string4);
                stringBuilder.append(" = ");
                object2 = dbTableMapper.Columns.get(string4);
                DbPreparedStatementParam dbPreparedStatementParam = dbHandler.getSqlPreparedStatementFormat(((DbTableMapperColumn)object2).Definition);
                stringBuilder.append(dbPreparedStatementParam.getSQL());
                hashMap.put(n, dbPreparedStatementParam.getParamType());
                ++n;
                string3 = " and ";
            }
        }
        try (Iterator<String> iterator = connection.prepareStatement(stringBuilder.toString());){
            for (Object object2 : list) {
                n = 1;
                for (DbTableMapperColumn dbTableMapperColumn : dbTableMapper.Columns.values()) {
                    if (Modifier.isTransient(dbTableMapperColumn.objectProperty.getModifiers())) continue;
                    DbManager.setPreparedStatementValue(iterator, dbTableMapperColumn, n, dbHandler, object2, (Integer)hashMap.get(n));
                    ++n;
                }
                if (dbHandlerMetadata.getPkList().size() > 0) {
                    for (String string5 : dbHandlerMetadata.getPkList()) {
                        DbTableMapperColumn dbTableMapperColumn = dbTableMapper.Columns.get(string5);
                        if (dbTableMapperColumn != null) {
                            DbManager.setPreparedStatementValue(iterator, dbTableMapperColumn, n, dbHandler, object2, (Integer)hashMap.get(n));
                            ++n;
                            continue;
                        }
                        throw new Exception("Unable to map primary key column " + string5 + " for table " + string2);
                    }
                }
                iterator.addBatch();
            }
            nArray = iterator.executeBatch();
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error updating records into database: " + exception.getMessage(), exception);
        }
        return nArray;
    }

    public static <T> int upsertObject(Connection connection, Class<T> clazz, String string, String string2, T t) throws ApplicationException {
        int[] nArray = DbManager.upsertObjects(connection, clazz, string, string2, new ArrayList<Object>(Arrays.asList(t)));
        return nArray[0];
    }

    public static <T> int[] upsertObjects(Connection connection, Class<T> clazz, String string, String string2, List<T> list) throws ApplicationException {
        int[] nArray = DbManager.updateObjects(connection, clazz, string, string2, list);
        ArrayList<T> arrayList = new ArrayList<T>();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != 0 && nArray[i] != -2) continue;
            arrayList.add(list.get(i));
        }
        if (arrayList.size() > 0) {
            DbManager.insertObjects(connection, clazz, string, string2, arrayList);
        }
        return nArray;
    }

    public static <T> List<T> selectObjects(Connection connection, Class<T> clazz, String string, String string2, String string3) throws ApplicationException {
        return DbManager.selectObjects(connection, clazz, string, string2, string3, null);
    }

    public static <T> List<T> selectObjects(Connection connection, Class<T> clazz, String string, String string2, String string3, DbQuerySetParams dbQuerySetParams) throws ApplicationException {
        ArrayList<T> arrayList = new ArrayList<T>();
        DbHandlerMetadataManager dbHandlerMetadataManager = DbHandlerMetadataManager.getInstance();
        DbTableMapper dbTableMapper = dbHandlerMetadataManager.getMapper(connection, clazz, string, string2);
        try (PreparedStatement preparedStatement = connection.prepareStatement(string3);){
            if (dbQuerySetParams != null) {
                dbQuerySetParams.setParameters(preparedStatement);
            }
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                ArrayList<DbTableMapperColumn> arrayList2 = new ArrayList<DbTableMapperColumn>();
                for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                    String string4 = resultSetMetaData.getColumnName(i);
                    for (DbTableMapperColumn n : dbTableMapper.Columns.values()) {
                        if (!string4.equalsIgnoreCase(n.ColumnName) || n.objectProperty == null) continue;
                        arrayList2.add(n);
                    }
                }
                while (resultSet.next()) {
                    T t = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    for (DbTableMapperColumn dbTableMapperColumn : arrayList2) {
                        if (dbTableMapperColumn.objectProperty.getType() == String.class) {
                            dbTableMapperColumn.objectProperty.set(t, resultSet.getString(dbTableMapperColumn.ColumnName));
                            continue;
                        }
                        if (dbTableMapperColumn.objectProperty.getType() == Date.class) {
                            Timestamp string5 = resultSet.getTimestamp(dbTableMapperColumn.ColumnName);
                            if (string5 == null) continue;
                            dbTableMapperColumn.objectProperty.set(t, new Date(string5.getTime()));
                            continue;
                        }
                        if (dbTableMapperColumn.objectProperty.getType() == Integer.TYPE) {
                            dbTableMapperColumn.objectProperty.setInt(t, resultSet.getInt(dbTableMapperColumn.ColumnName));
                            continue;
                        }
                        if (dbTableMapperColumn.objectProperty.getType() == Integer.class) {
                            int n = resultSet.getInt(dbTableMapperColumn.ColumnName);
                            if (resultSet.wasNull()) continue;
                            dbTableMapperColumn.objectProperty.set(t, n);
                            continue;
                        }
                        if (dbTableMapperColumn.objectProperty.getType() == Long.TYPE) {
                            dbTableMapperColumn.objectProperty.setLong(t, resultSet.getLong(dbTableMapperColumn.ColumnName));
                            continue;
                        }
                        if (dbTableMapperColumn.objectProperty.getType().isEnum()) {
                            String string4 = resultSet.getString(dbTableMapperColumn.ColumnName);
                            dbTableMapperColumn.objectProperty.set(t, Enum.valueOf(dbTableMapperColumn.objectProperty.getType(), string4));
                            continue;
                        }
                        if (dbTableMapperColumn.objectProperty.getType() == Boolean.TYPE) {
                            dbTableMapperColumn.objectProperty.setBoolean(t, Util.intToBoolean(resultSet.getInt(dbTableMapperColumn.ColumnName)));
                            continue;
                        }
                        if (dbTableMapperColumn.objectProperty.getType() == Boolean.class) {
                            int n = resultSet.getInt(dbTableMapperColumn.ColumnName);
                            if (resultSet.wasNull()) continue;
                            dbTableMapperColumn.objectProperty.set(t, Util.intToBoolean(n));
                            continue;
                        }
                        dbTableMapperColumn.objectProperty.set(t, resultSet.getObject(dbTableMapperColumn.ColumnName));
                    }
                    arrayList.add(t);
                }
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "error selecting data from database: " + exception.getMessage(), exception);
        }
        return arrayList;
    }

    public static <T> List<T> selectObjects(Connection connection, String string, DbQueryResultsReader<T> dbQueryResultsReader) throws ApplicationException {
        return DbManager.selectObjects(connection, string, null, dbQueryResultsReader);
    }

    public static <T> List<T> selectObjects(Connection connection, String string, DbQuerySetParams dbQuerySetParams, DbQueryResultsReader<T> dbQueryResultsReader) throws ApplicationException {
        ArrayList<T> arrayList = new ArrayList<T>();
        try (PreparedStatement preparedStatement = connection.prepareStatement(string);){
            if (dbQuerySetParams != null) {
                dbQuerySetParams.setParameters(preparedStatement);
            }
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    T t = dbQueryResultsReader.loadFromRset(resultSet);
                    arrayList.add(t);
                }
                resultSet.close();
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "error selecting data from database: " + exception.getMessage(), exception);
        }
        return arrayList;
    }

    public static Date readDate(ResultSet resultSet, String string) throws SQLException {
        Timestamp timestamp = resultSet.getTimestamp(string);
        if (resultSet.wasNull()) {
            return null;
        }
        return new Date(timestamp.getTime());
    }

    @SuppressFBWarnings(value={"DE_MIGHT_IGNORE"}, justification="Do not need to report exception closing CsvWriter under error conditions. This class does not implement Closeable interface")
    public static int tableExport(Connection connection, String string, String string2, String string3, PrintWriter printWriter) throws ApplicationException {
        int n = 0;
        CsvWriter csvWriter = null;
        try {
            String string4 = "select * from " + string;
            if (!Util.isBlank(string2)) {
                string4 = string4 + " where " + string2;
            }
            if (!Util.isBlank(string3)) {
                string4 = string4 + " order by " + string3;
            }
            try (Statement statement = connection.createStatement();
                 ResultSet resultSet = statement.executeQuery(string4);){
                int n2;
                csvWriter = new CsvWriter(printWriter);
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                csvWriter.put("I");
                csvWriter.put("");
                csvWriter.put(string);
                for (n2 = 1; n2 <= resultSetMetaData.getColumnCount(); ++n2) {
                    csvWriter.put(resultSetMetaData.getColumnName(n2));
                }
                csvWriter.nl();
                ++n;
                while (resultSet.next()) {
                    csvWriter.put("D");
                    csvWriter.put("");
                    csvWriter.put(string);
                    for (n2 = 1; n2 <= resultSetMetaData.getColumnCount(); ++n2) {
                        if (resultSetMetaData.getColumnType(n2) == 91 || resultSetMetaData.getColumnType(n2) == 92 || resultSetMetaData.getColumnType(n2) == 93) {
                            csvWriter.put(Util.dateToStr(resultSet.getTimestamp(n2), "dd/MM/yyyy HH:mm:ss"));
                            continue;
                        }
                        csvWriter.put(resultSet.getString(n2));
                    }
                    csvWriter.nl();
                    ++n;
                }
                csvWriter.flush();
            }
        }
        catch (Exception exception) {
            if (csvWriter != null) {
                try {
                    csvWriter.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            Util_Logger.error(logger, "Error exporting " + string + ": " + exception.getMessage(), exception);
        }
        return n;
    }

    public static int tableExport(Connection connection, String string, String string2, PrintWriter printWriter) throws ApplicationException {
        return DbManager.tableExport(connection, string, null, string2, printWriter);
    }

    public static boolean runScript(Connection connection, String string, String string2, Boolean bl, boolean bl2, ConfigurationValueResolver configurationValueResolver, boolean bl3) throws Exception {
        boolean bl4 = false;
        try {
            try (FileReader fileReader = new FileReader(string);){
                DbScriptRunner dbScriptRunner = new DbScriptRunner(connection, false, true);
                if (!Util.isBlank(string2)) {
                    dbScriptRunner.setFullLineDelimiter(string2);
                }
                dbScriptRunner.setIgnorePKViolations(bl2);
                dbScriptRunner.setVariableResolver(configurationValueResolver);
                dbScriptRunner.setDebug(bl3);
                if (bl != null) {
                    dbScriptRunner.setAutoCommit(bl);
                }
                dbScriptRunner.runScript(fileReader);
            }
            bl4 = true;
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error executing script " + string + ": " + exception.getMessage(), exception);
        }
        return bl4;
    }
}

