/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.FTP;

import au.com.aemo.Common.FTP.FtpConfig;
import au.com.aemo.Common.FTP.FtpConnectionIntBase;
import au.com.aemo.Common.FTP.FtpException;
import au.com.aemo.Common.FTP.PrintCommandListener;
import au.com.aemo.Common.FileSystem.fsConnectionFileFilterInt;
import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.FileSystem.fsFileTypeEnum;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPHTTPClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpConnectionIntApache
extends FtpConnectionIntBase {
    private static Logger logger = LoggerFactory.getLogger(FtpConnectionIntApache.class);
    private FTPClient itsFtp;
    private boolean itsLoggedBandwidthWarning = false;
    private SimpleDateFormat modTimeDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");

    @Override
    public String toString() {
        return this.getId();
    }

    @Override
    public void connect(FtpConfig ftpConfig) throws Exception {
        this.setId(ftpConfig.connectionId);
        this.setExtractLastModifiedDate(ftpConfig.extractLastModifiedDate);
        this.itsFtp = Util.isBlank(ftpConfig.proxyAdress) ? new FTPClient() : new FTPHTTPClient(ftpConfig.proxyAdress, Integer.parseInt(ftpConfig.proxyPort), ftpConfig.username, ftpConfig.password);
        if (logger.isDebugEnabled()) {
            this.itsFtp.addProtocolCommandListener((ProtocolCommandListener)new PrintCommandListener(logger, this.getId()));
        }
        if (ftpConfig.port == null) {
            this.itsFtp.connect(ftpConfig.host);
        } else {
            this.itsFtp.connect(ftpConfig.host, ftpConfig.port.intValue());
        }
        if (ftpConfig.connectMode.equalsIgnoreCase("active")) {
            this.itsFtp.enterLocalActiveMode();
        } else if (ftpConfig.connectMode.equalsIgnoreCase("passive")) {
            this.itsFtp.enterLocalPassiveMode();
        } else {
            throw new Exception("Unknown FTP connect mode " + ftpConfig.connectMode);
        }
        this.itsFtp.setDataTimeout(Duration.ofSeconds(ftpConfig.timeoutSeconds));
        this.itsFtp.login(ftpConfig.username, ftpConfig.password);
        try {
            String string = "App: " + ftpConfig.applicationId;
            try {
                String string2 = InetAddress.getLocalHost().getHostName();
                string = string + "; Host:" + string2;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.itsFtp.sendCommand(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void disconnect() throws FtpException, IOException {
        try {
            this.itsFtp.disconnect();
        }
        catch (Exception exception) {
            throw new FtpException(exception, this.itsFtp.getReplyCode());
        }
    }

    @Override
    public boolean isConnected() {
        boolean bl = false;
        try {
            bl = this.itsFtp.isConnected();
            if (bl) {
                bl = this.itsFtp.sendNoOp();
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private void logBandwidthWarning() {
        if (!this.itsLoggedBandwidthWarning) {
            Util_Logger.warning(logger, "Bandwidth throttling not supported in Apache FTP provider");
            this.itsLoggedBandwidthWarning = true;
        }
    }

    @Override
    public void setBandwidthThrottle(int n) {
        this.logBandwidthWarning();
    }

    @Override
    public void resetBandwidthThrottle() {
    }

    @Override
    public void setTransferBufferSize(int n) {
        Util_Logger.warning(logger, "Transfer buffer size not supported in Apache FTP provider");
    }

    @Override
    public void chdirImp(String string) throws FtpException, IOException {
        boolean bl = false;
        try {
            bl = this.itsFtp.changeWorkingDirectory(string);
        }
        catch (Exception exception) {
            throw new FtpException(exception, this.itsFtp.getReplyCode());
        }
        if (!bl) {
            throw new FtpException("Failed to change directory to " + string + ": " + this.itsFtp.getReplyString() + ", FTP reply code = " + this.itsFtp.getReplyCode(), this.itsFtp.getReplyCode());
        }
    }

    @Override
    public void mkdir(String string) throws FtpException, IOException {
        boolean bl = false;
        try {
            bl = this.itsFtp.makeDirectory(string);
        }
        catch (Exception exception) {
            throw new FtpException(exception, this.itsFtp.getReplyCode());
        }
        if (!bl) {
            throw new FtpException("Failed to make directory to " + string + ": " + this.itsFtp.getReplyString() + ", FTP reply code = " + this.itsFtp.getReplyCode(), this.itsFtp.getReplyCode());
        }
    }

    @Override
    public void setType(String string) throws FtpException, IOException {
        boolean bl = false;
        int n = 0;
        if (!string.equalsIgnoreCase("binary")) {
            throw new FtpException("Unknown FTP transfer mode " + string);
        }
        n = 2;
        try {
            bl = this.itsFtp.setFileType(n);
        }
        catch (Exception exception) {
            throw new FtpException(exception, this.itsFtp.getReplyCode());
        }
        if (!bl) {
            throw new FtpException("Failed to set transfer type to " + string + ": " + this.itsFtp.getReplyString() + ", FTP reply code = " + this.itsFtp.getReplyCode(), this.itsFtp.getReplyCode());
        }
    }

    @Override
    public void put(String string, String string2) throws FtpException, IOException {
        boolean bl = false;
        try (FileInputStream fileInputStream = new FileInputStream(string);){
            bl = this.itsFtp.storeFile(string2, (InputStream)fileInputStream);
        }
        catch (Exception exception) {
            throw new FtpException(exception, this.itsFtp.getReplyCode());
        }
        if (!bl) {
            throw new FtpException("Failed to put file " + string2 + ": " + this.itsFtp.getReplyString() + ", FTP reply code = " + this.itsFtp.getReplyCode(), this.itsFtp.getReplyCode());
        }
    }

    @Override
    public fsFileInfo[] dir(String string, fsConnectionFileFilterInt fsConnectionFileFilterInt2) throws FtpException, IOException {
        fsFileInfo[] fsFileInfoArray;
        block11: {
            fsFileInfoArray = null;
            try {
                FTPFile[] fTPFileArray;
                Object object = string;
                if (fsConnectionFileFilterInt2 != null && !Util.isBlank(fsConnectionFileFilterInt2.getServerDirectoryListingFileMask())) {
                    object = (String)object + "/" + fsConnectionFileFilterInt2.getServerDirectoryListingFileMask();
                }
                if ((fTPFileArray = this.itsFtp.listFiles((String)object)) == null) break block11;
                ArrayList<fsFileInfo> arrayList = new ArrayList<fsFileInfo>();
                for (int i = 0; i < fTPFileArray.length; ++i) {
                    boolean bl = true;
                    fsFileInfo fsFileInfo2 = new fsFileInfo();
                    fsFileInfo2.setDirectory(string);
                    fsFileInfo2.setFilename(fTPFileArray[i].getName());
                    fsFileInfo2.setSize(fTPFileArray[i].getSize());
                    fsFileInfo2.setModifiedDate(fTPFileArray[i].getTimestamp().getTime(), false);
                    if (fTPFileArray[i].isDirectory()) {
                        fsFileInfo2.setFileType(fsFileTypeEnum.DIRECTORY);
                    } else {
                        fsFileInfo2.setFileType(fsFileTypeEnum.FILE);
                        if (this.getExtractLastModifiedDate()) {
                            try {
                                String string2 = this.itsFtp.getModificationTime(string + "/" + fTPFileArray[i].getName());
                                if (!Util.isBlank(string2)) {
                                    Date date = this.modTimeDateFormat.parse(string2.substring(string2.indexOf(" ") + 1));
                                    fsFileInfo2.setModifiedDate(date, true);
                                }
                            }
                            catch (Exception exception) {
                                if (this.itsFtp.getReplyCode() != 550) {
                                    throw new FtpException(exception, this.itsFtp.getReplyCode());
                                }
                                bl = false;
                            }
                        }
                    }
                    if (!bl) continue;
                    arrayList.add(fsFileInfo2);
                }
                fsFileInfoArray = arrayList.toArray(new fsFileInfo[0]);
            }
            catch (Exception exception) {
                throw new FtpException(exception, this.itsFtp.getReplyCode());
            }
        }
        return fsFileInfoArray;
    }

    @Override
    public void delete(String string) throws FtpException, IOException {
        boolean bl = false;
        try {
            bl = this.itsFtp.deleteFile(string);
        }
        catch (Exception exception) {
            throw new FtpException(exception, this.itsFtp.getReplyCode());
        }
        if (!bl) {
            throw new FtpException("Failed to delete file " + string + ": " + this.itsFtp.getReplyString() + ", FTP reply code = " + this.itsFtp.getReplyCode(), this.itsFtp.getReplyCode());
        }
    }

    @Override
    public void get(String string, String string2) throws FtpException, IOException {
        boolean bl = false;
        try (FileOutputStream fileOutputStream = new FileOutputStream(string + "/" + string2);){
            bl = this.itsFtp.retrieveFile(string2, (OutputStream)fileOutputStream);
        }
        catch (Exception exception) {
            throw new FtpException(exception, this.itsFtp.getReplyCode());
        }
        if (!bl) {
            throw new FtpException("Failed to get file " + string2 + ": " + this.itsFtp.getReplyString() + ", FTP reply code = " + this.itsFtp.getReplyCode(), this.itsFtp.getReplyCode());
        }
    }

    @Override
    public boolean exists(String string, String string2) throws FtpException {
        try {
            fsFileInfo[] fsFileInfoArray = this.dir(string + "/" + string2, null);
            return fsFileInfoArray != null;
        }
        catch (Exception exception) {
            throw new FtpException(exception, this.itsFtp.getReplyCode());
        }
    }

    @Override
    public boolean exists(fsFileInfo fsFileInfo2) throws FtpException, IOException {
        boolean bl = false;
        try {
            String string = this.itsFtp.getModificationTime(fsFileInfo2.getDirectory() + "/" + fsFileInfo2.getFilename());
            if (!Util.isBlank(string)) {
                Date date = this.modTimeDateFormat.parse(string.substring(string.indexOf(" ") + 1));
                fsFileInfo2.setModifiedDate(date, true);
                bl = true;
            }
        }
        catch (Exception exception) {
            throw new FtpException(exception, this.itsFtp.getReplyCode());
        }
        return bl;
    }

    @Override
    public void rename(String string, String string2) throws FtpException {
        try {
            this.itsFtp.rename(string, string2);
        }
        catch (Exception exception) {
            throw new FtpException(exception, this.itsFtp.getReplyCode());
        }
    }
}

