/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.FTP;

import au.com.aemo.Common.FTP.FtpConnectionInt;
import au.com.aemo.Common.FTP.FtpConnectionPoolFactory;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FtpConnectionPool {
    private static Logger logger = LoggerFactory.getLogger(FtpConnectionPool.class);
    private volatile GenericObjectPool<FtpConnectionInt> itsPool;
    private Date itsPoolLastCleared;
    private int itsPoolTimeoutMins;
    private String itsId;
    private String itsConfigId;
    private Properties itsConfiguration;
    private FtpConnectionPoolFactory itsFactory;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Private constructor")
    public FtpConnectionPool(String string, String string2, Properties properties, String string3) {
        this.itsId = string2;
        this.itsConfigId = string + "_" + this.itsId + "_";
        this.itsConfiguration = properties;
        this.itsFactory = new FtpConnectionPoolFactory(string, string2, properties, string3){

            @Override
            public synchronized PooledObject<FtpConnectionInt> makeObject() throws Exception {
                PooledObject<FtpConnectionInt> pooledObject = super.makeObject();
                FtpConnectionPool.this.logConnectionPoolState(1);
                return pooledObject;
            }

            @Override
            public void destroyObject(PooledObject<FtpConnectionInt> pooledObject) throws Exception {
                super.destroyObject(pooledObject);
                FtpConnectionPool.this.logConnectionPoolState(0);
            }
        };
        this.createFtpConnectionPool();
    }

    public String getId() {
        return this.itsId;
    }

    private void createFtpConnectionPool() {
        if (this.itsPool != null) {
            try {
                this.itsPool.clear();
                this.itsPool.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        GenericObjectPoolConfig genericObjectPoolConfig = new GenericObjectPoolConfig();
        genericObjectPoolConfig.setBlockWhenExhausted(true);
        genericObjectPoolConfig.setMaxTotal(Integer.parseInt(Util.getProperty(this.itsConfiguration, this.itsConfigId + "ftp_max_connections", "5")));
        genericObjectPoolConfig.setTestWhileIdle(true);
        genericObjectPoolConfig.setTimeBetweenEvictionRuns(Duration.ofSeconds(Long.parseLong(Util.getProperty(this.itsConfiguration, this.itsConfigId + "ftp_eviction_cycle", "120"))));
        genericObjectPoolConfig.setMinEvictableIdleTime(Duration.ofSeconds(Integer.parseInt(Util.getProperty(this.itsConfiguration, this.itsConfigId + "ftp_eviction_timeout", "1800"))));
        genericObjectPoolConfig.setTestOnBorrow(true);
        genericObjectPoolConfig.setTestOnReturn(true);
        genericObjectPoolConfig.setLifo(true);
        genericObjectPoolConfig.setMaxWait(Duration.ofSeconds(Integer.parseInt(Util.getProperty(this.itsConfiguration, this.itsConfigId + "ftp_max_wait", "30"))));
        this.itsPool = new GenericObjectPool((PooledObjectFactory)this.itsFactory);
        this.itsPool.setConfig(genericObjectPoolConfig);
        this.itsPoolLastCleared = new Date();
        this.itsPoolTimeoutMins = Integer.parseInt(Util.getProperty(this.itsConfiguration, this.itsConfigId + "ftp_pool_timeout", "10"));
    }

    public FtpConnectionInt getConnection() {
        FtpConnectionInt ftpConnectionInt = null;
        try {
            ftpConnectionInt = (FtpConnectionInt)this.itsPool.borrowObject();
            ftpConnectionInt.chdir("/");
            ftpConnectionInt.setType("binary");
            ftpConnectionInt.resetBandwidthThrottle();
            Util_Logger.debug(logger, "Borrowed FTP connection [" + ftpConnectionInt.getId() + "]");
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to borrow FTP connection from object pool: " + exception.getMessage(), exception);
        }
        return ftpConnectionInt;
    }

    public void returnConnection(FtpConnectionInt ftpConnectionInt) {
        if (ftpConnectionInt != null) {
            try {
                Util_Logger.debug(logger, "Returned FTP connection [" + ftpConnectionInt.getId() + "]");
                ftpConnectionInt.resetBandwidthThrottle();
                this.itsPool.returnObject((Object)ftpConnectionInt);
            }
            catch (Exception exception) {
                throw new RuntimeException("Unable to return FTP connection to object pool: " + exception.getMessage(), exception);
            }
        }
    }

    private void logConnectionPoolState(int n) {
        if (this.itsPool != null) {
            Util_Logger.info(logger, "FTP Connection pool [" + this.itsId + "] now has a total of " + (this.itsPool.getNumActive() + n) + " active connections, " + this.itsPool.getNumIdle() + " idle connections");
        }
    }

    public synchronized void clearCache() {
        try {
            Date date = Util.dateOffset(new Date(), -this.itsPoolTimeoutMins, 12);
            if (this.itsPoolLastCleared.before(date)) {
                this.createFtpConnectionPool();
                Util_Logger.warning(logger, "Flushed FTP connection pool");
            }
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error clearing object pool cache for FtpConnectionPool:" + exception.getMessage(), exception);
        }
    }
}

