/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.FileSystem;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.FileSystem.fsConnectionFactoryAMQP;
import au.com.aemo.Common.FileSystem.fsConnectionFactoryAPI;
import au.com.aemo.Common.FileSystem.fsConnectionFactoryAWS;
import au.com.aemo.Common.FileSystem.fsConnectionFactoryAzure;
import au.com.aemo.Common.FileSystem.fsConnectionFactoryEHub;
import au.com.aemo.Common.FileSystem.fsConnectionFactoryFtp;
import au.com.aemo.Common.FileSystem.fsConnectionFactoryGoogle;
import au.com.aemo.Common.FileSystem.fsConnectionFactoryGraphQL;
import au.com.aemo.Common.FileSystem.fsConnectionFactoryInt;
import au.com.aemo.Common.FileSystem.fsConnectionFactoryLocal;
import au.com.aemo.Common.FileSystem.fsConnectionFactoryNull;
import au.com.aemo.Common.FileSystem.fsConnectionFactoryWeb;
import au.com.aemo.Common.FileSystem.fsConnectionFactoryWebhook;
import au.com.aemo.Common.FileSystem.fsConnectionInt;
import au.com.aemo.Common.FileSystem.fsDataSource;
import au.com.aemo.Common.FileSystem.fsEventData;
import au.com.aemo.Common.FileSystem.fsEventListenerInt;
import au.com.aemo.Common.FileSystem.fsEventNotificationFactory;
import au.com.aemo.Common.FileSystem.fsEventNotificationInt;
import au.com.aemo.Common.FileSystem.fsInactivityEventListenerInt;
import au.com.aemo.Common.JSON.JsonTransformManager;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Web.WebClientAuthAPIKey;
import au.com.aemo.Common.Web.WebClientAuthBase;
import au.com.aemo.Common.Web.WebClientAuthBasic;
import au.com.aemo.Common.Web.WebClientAuthInt;
import au.com.aemo.Common.Web.WebClientAuthNone;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesystemManager {
    private static Logger logger = LoggerFactory.getLogger(FilesystemManager.class);
    public static final String PROTOCOL_FTP = "FTP";
    public static final String PROTOCOL_LOCAL = "LOCAL";
    public static final String PROTOCOL_WEB = "WEB";
    public static final String PROTOCOL_NULL = "NULL";
    public static final String PROTOCOL_AZURE = "AZURE";
    public static final String PROTOCOL_AWS = "AWS";
    public static final String PROTOCOL_API = "API";
    public static final String PROTOCOL_GOOGLE = "GOOGLE";
    public static final String PROTOCOL_GRAPHQL = "GRAPHQL";
    public static final String PROTOCOL_WEBHOOK = "WEBHOOK";
    public static final String PROTOCOL_EHUB = "EHUB";
    public static final String PROTOCOL_AMQP = "AMQP";
    public static final String EVENT_SIGNALR = "SIGNALR";
    public static final String EVENT_AMQP = "AMQP";
    public static final String EVENT_WEBSOCKET = "WEBSOCKET";
    public static final String SOURCE_INTERNAL = "internal";
    private String itsAppName;
    private String itsAppVersion;
    private String itsConfigPrefix;
    private Properties itsConfiguration;
    private Map<String, fsConnectionFactoryInt> itsDataSourceFactories;
    private Map<String, fsEventNotificationInt> itsProducers = new HashMap<String, fsEventNotificationInt>();
    private Map<String, fsEventNotificationInt> itsConsumers = new HashMap<String, fsEventNotificationInt>();
    private fsInactivityEventListenerInt itsInactivityListener;
    private Map<String, fsDataSource> itsDataSources;
    private Date itsStartTime;
    private boolean isReady = false;

    private FilesystemManager() {
        this.itsDataSourceFactories = new HashMap<String, fsConnectionFactoryInt>();
        this.registerDataSourceFactory(fsConnectionFactoryFtp.getInstance());
        this.registerDataSourceFactory(fsConnectionFactoryLocal.getInstance());
        this.registerDataSourceFactory(fsConnectionFactoryWeb.getInstance());
        this.registerDataSourceFactory(fsConnectionFactoryNull.getInstance());
        this.registerDataSourceFactory(fsConnectionFactoryAzure.getInstance());
        this.registerDataSourceFactory(fsConnectionFactoryAWS.getInstance());
        this.registerDataSourceFactory(fsConnectionFactoryAPI.getInstance());
        this.registerDataSourceFactory(fsConnectionFactoryGoogle.getInstance());
        this.registerDataSourceFactory(fsConnectionFactoryGraphQL.getInstance());
        this.registerDataSourceFactory(fsConnectionFactoryWebhook.getInstance());
        this.registerDataSourceFactory(fsConnectionFactoryEHub.getInstance());
        this.registerDataSourceFactory(fsConnectionFactoryAMQP.getInstance());
    }

    public static FilesystemManager getInstance() {
        return SingletonHolder.instance;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Method is consumed by trusted code")
    public void configure(String string, String string2, String string3, Properties properties) {
        this.itsAppName = string;
        this.itsAppVersion = string2;
        this.itsConfigPrefix = string3;
        this.itsConfiguration = properties;
    }

    public void start() throws Exception {
        Util_Logger.info(logger, "Starting filesystem manager with config prefix [" + this.itsConfigPrefix + "]");
        try {
            Object object;
            Object object2;
            String string;
            this.itsDataSources = new HashMap<String, fsDataSource>();
            String string2 = this.getConfig("data_sources", null);
            if (!Util.isBlank(string2)) {
                String[] stringArray3 = Util.getColumns(string2, ',');
                for (String stringArray22 : stringArray3) {
                    String string3;
                    if (Util.isBlank(stringArray22)) continue;
                    String[] stringArray = this.getConfig((String)stringArray22 + "_mode", PROTOCOL_LOCAL);
                    fsDataSource fsDataSource2 = new fsDataSource(stringArray22, (String)stringArray);
                    String string4 = this.getConfig((String)stringArray22 + "_send_inactivity_timeout", "");
                    if (!Util.isBlank(string4) && Util.isInteger(string4)) {
                        int n = Integer.valueOf(string4);
                        fsDataSource2.setSendInactivityTimeoutSecs(n);
                    }
                    if (!Util.isBlank(string3 = this.getConfig((String)stringArray22 + "_send_inactivity_failover_secs", "")) && Util.isInteger(string3)) {
                        int n = Integer.valueOf(string3);
                        fsDataSource2.setSendInactivityFailoverSecs(n);
                    }
                    fsDataSource2.setSendInactivityDataSource(this.getConfig((String)stringArray22 + "_send_inactivity_failover_data_source", ""));
                    string = this.getConfig((String)stringArray22 + "_receive_inactivity_timeout", "");
                    if (!Util.isBlank(string) && Util.isInteger(string)) {
                        int n = Integer.valueOf(string);
                        fsDataSource2.setReceiveInactivityTimeoutSecs(n);
                    }
                    if (!Util.isBlank((String)(object2 = this.getConfig((String)stringArray22 + "_receive_inactivity_failover_secs", ""))) && Util.isInteger((String)object2)) {
                        int n = Integer.valueOf((String)object2);
                        fsDataSource2.setReceiveInactivityFailoverSecs(n);
                    }
                    fsDataSource2.setReceiveInactivityDataSource(this.getConfig((String)stringArray22 + "_receive_inactivity_failover_data_source", ""));
                    object = this.getConfig((String)stringArray22 + "_reset_frequency_secs", "");
                    if (!Util.isBlank((String)object) && Util.isInteger((String)object)) {
                        int n = Integer.valueOf((String)object);
                        fsDataSource2.setResetFrequencySecs(n);
                    }
                    this.addDataSource(fsDataSource2);
                }
            }
            boolean bl = true;
            for (fsDataSource fsDataSource3 : this.itsDataSources.values()) {
                int n;
                if (!Util.isBlank(fsDataSource3.getSendInactivityDataSource())) {
                    if (fsDataSource3.getSendInactivityFailoverSecs() == null) {
                        Util_Logger.errorNoRaise(logger, "Detected missing configuration for [" + fsDataSource3.getName() + "_send_inactivity_failover_secs] which has send failover data source defined");
                        bl = false;
                    }
                    n = 0;
                    for (String[] stringArray : this.itsDataSources.values()) {
                        if (!fsDataSource3.getSendInactivityDataSource().equalsIgnoreCase(stringArray.getName())) continue;
                        n = 1;
                    }
                    if (n == 0) {
                        Util_Logger.errorNoRaise(logger, "Detected invalid send inactivity data source configuration [" + fsDataSource3.getSendInactivityDataSource() + "] for data source [" + fsDataSource3.getName() + "]");
                        bl = false;
                    }
                }
                if (Util.isBlank(fsDataSource3.getReceiveInactivityDataSource())) continue;
                if (fsDataSource3.getReceiveInactivityFailoverSecs() == null) {
                    Util_Logger.errorNoRaise(logger, "Detected missing configuration for [" + fsDataSource3.getName() + "_receive_inactivity_failover_secs] which has receive failover data source defined");
                    bl = false;
                }
                n = 0;
                for (String[] stringArray : this.itsDataSources.values()) {
                    if (!fsDataSource3.getReceiveInactivityDataSource().equalsIgnoreCase(stringArray.getName())) continue;
                    n = 1;
                }
                if (n != 0) continue;
                Util_Logger.errorNoRaise(logger, "Detected invalid receive inactivity data source configuration [" + fsDataSource3.getSendInactivityDataSource() + "] for data source [" + fsDataSource3.getName() + "]");
                bl = false;
            }
            if (!bl) {
                Util_Logger.error(logger, "Aborting startup due to invalid data source configuration");
            }
            for (fsDataSource fsDataSource4 : this.itsDataSources.values()) {
                fsConnectionFactoryInt fsConnectionFactoryInt2 = this.getDataSourceFactory(fsDataSource4.getProtocol());
                fsConnectionFactoryInt2.setIsActive(true);
            }
            Util_Logger.info(logger, "Registered [" + this.itsDataSources.size() + "] data sources with [" + this.itsDataSourceFactories.size() + "] factory protocol providers");
            boolean bl2 = true;
            for (fsConnectionFactoryInt fsConnectionFactoryInt3 : this.itsDataSourceFactories.values()) {
                if (!fsConnectionFactoryInt3.getIsActive()) continue;
                Util_Logger.info(logger, "Starting " + fsConnectionFactoryInt3.getName() + " data source factory");
                fsConnectionFactoryInt3.start();
                bl2 = bl2 && fsConnectionFactoryInt3.getIsRunning();
            }
            JsonTransformManager.getInstance().loadTransformConfig();
            this.itsProducers = new HashMap<String, fsEventNotificationInt>();
            fsEventNotificationFactory fsEventNotificationFactory2 = fsEventNotificationFactory.getInstance();
            String string5 = this.getConfig("event_sources", null);
            if (!Util.isBlank(string5)) {
                String[] stringArray;
                for (String string3 : stringArray = Util.getColumns(string5, ',')) {
                    if (Util.isBlank(string3)) continue;
                    string = this.getConfig(string3 + "_provider", null);
                    if (!Util.isBlank(string)) {
                        object2 = fsEventNotificationFactory2.getFactory(string);
                        if (object2 == null) {
                            Util_Logger.error(logger, "Invalid provider [" + string + "] detected for event source [" + string3 + "]");
                        }
                        object = object2.createInstance(string3);
                        this.itsProducers.put(string3.toUpperCase(), (fsEventNotificationInt)object);
                        continue;
                    }
                    Util_Logger.error(logger, "Missing provider configuration for event provider [" + string3 + "]");
                }
            }
            this.itsStartTime = new Date();
            this.isReady = bl2;
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error starting FilesystemManager: " + exception.getMessage(), exception);
        }
        if (!this.isReady) {
            throw new Exception("Error starting filesystem manager");
        }
    }

    public void stop() {
        if (this.isReady) {
            Util_Logger.info(logger, "Stopping filesystem manager with config prefix [" + this.itsConfigPrefix + "]");
            for (Map.Entry<String, fsEventNotificationInt> object : this.itsProducers.entrySet()) {
                Util_Logger.info(logger, "Stopping " + object.getKey() + " event notification provider");
                object.getValue().stop();
            }
            for (fsConnectionFactoryInt fsConnectionFactoryInt2 : this.itsDataSourceFactories.values()) {
                if (!fsConnectionFactoryInt2.getIsRunning()) continue;
                Util_Logger.debug(logger, "Stopping " + fsConnectionFactoryInt2.getName() + " data source factory");
                fsConnectionFactoryInt2.stop();
            }
        }
    }

    public String getAppName() {
        return this.itsAppName;
    }

    public String getAppVersion() {
        return this.itsAppVersion;
    }

    public String getConfigPrefix() {
        return this.itsConfigPrefix;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Method is consumed by trusted code")
    public Properties getConfiguration() {
        return this.itsConfiguration;
    }

    public String getConfig(String string, String string2) {
        return Util.getProperty(this.itsConfiguration, this.itsConfigPrefix + "_" + string, string2);
    }

    public void registerDataSourceFactory(fsConnectionFactoryInt fsConnectionFactoryInt2) {
        this.itsDataSourceFactories.put(fsConnectionFactoryInt2.getName().toUpperCase(), fsConnectionFactoryInt2);
    }

    public boolean getIsReady() {
        return this.isReady;
    }

    public fsConnectionFactoryInt getDataSourceFactory(String string) {
        return this.itsDataSourceFactories.get(string.toUpperCase());
    }

    public fsDataSource getDataSource(String string) {
        fsDataSource fsDataSource2 = null;
        if (this.itsDataSources != null) {
            fsDataSource2 = this.itsDataSources.get(string.toUpperCase());
        }
        return fsDataSource2;
    }

    private void addDataSource(fsDataSource fsDataSource2) {
        if (fsDataSource2 != null) {
            this.itsDataSources.put(fsDataSource2.getName().toUpperCase(), fsDataSource2);
        }
    }

    public void updateSendActivity(String string, int n, double d) {
        fsDataSource fsDataSource2 = this.getDataSource(string);
        if (fsDataSource2 != null) {
            fsDataSource2.updateSendActivity(n, d);
        }
    }

    public void updateReceiveActivity(String string, int n, double d) {
        fsDataSource fsDataSource2 = this.getDataSource(string);
        if (fsDataSource2 != null) {
            fsDataSource2.updateReceiveActivity(n, d);
        }
    }

    public void registerInactvityListener(fsInactivityEventListenerInt fsInactivityEventListenerInt2) {
        this.itsInactivityListener = fsInactivityEventListenerInt2;
    }

    public void performInactivityCheck() {
        if (this.itsDataSources != null) {
            try {
                Util_Logger.info(logger, "Performing data source inactivity check");
                Date date = new Date();
                for (fsDataSource fsDataSource2 : this.itsDataSources.values()) {
                    Object object;
                    boolean bl = true;
                    if (fsDataSource2.getSendInactivityTimeoutSecs() != null) {
                        Date date2 = Util.dateOffset(date, -fsDataSource2.getSendInactivityTimeoutSecs().intValue(), 13);
                        object = fsDataSource2.getLastSendActivity();
                        if (object == null) {
                            object = this.itsStartTime;
                        }
                        if (((Date)object).before(date2)) {
                            bl = false;
                            Util_Logger.warning(logger, "Detected send inactivity timeout on data source [" + fsDataSource2.getName() + "], last activity was at " + Util.dateToStr((Date)object, "dd-MM-yyyy HH:mm:ss"));
                        }
                    }
                    boolean bl2 = true;
                    if (fsDataSource2.getReceiveInactivityTimeoutSecs() != null) {
                        object = Util.dateOffset(date, -fsDataSource2.getReceiveInactivityTimeoutSecs().intValue(), 13);
                        Date date3 = fsDataSource2.getLastReceiveActivity();
                        if (date3 == null) {
                            date3 = this.itsStartTime;
                        }
                        if (date3.before((Date)object)) {
                            bl2 = false;
                            Util_Logger.warning(logger, "Detected receive inactivity timeout on data source [" + fsDataSource2.getName() + "], last activity was at " + Util.dateToStr(date3, "dd-MM-yyyy HH:mm:ss"));
                        }
                    }
                    if (!(bl && bl2 || !fsDataSource2.resetIsDue() || (object = this.getDataSourceFactory(fsDataSource2.getProtocol())) == null)) {
                        Util_Logger.warning(logger, "Resetting connections to data source [" + fsDataSource2.getName() + "]");
                        object.resetPool(fsDataSource2.getName());
                        fsDataSource2.wasReset();
                    }
                    if (bl && fsDataSource2.getSendFailOverState() && this.itsInactivityListener != null) {
                        this.itsInactivityListener.deactivateBackupDataSource(fsDataSource2.getSendInactivityDataSource());
                        fsDataSource2.setSendFailOverState(false);
                    }
                    if (bl2 && fsDataSource2.getReceiveFailOverState() && this.itsInactivityListener != null) {
                        this.itsInactivityListener.deactivateBackupDataSource(fsDataSource2.getReceiveInactivityDataSource());
                        fsDataSource2.setReceiveFailOverState(false);
                    }
                    if (!fsDataSource2.getSendFailOverState() && fsDataSource2.checkSendFailoverTimeout() && this.itsInactivityListener != null) {
                        this.itsInactivityListener.activateBackupDataSource(fsDataSource2.getSendInactivityDataSource());
                        fsDataSource2.setSendFailOverState(true);
                    }
                    if (fsDataSource2.getReceiveFailOverState() || !fsDataSource2.checkReceiveFailoverTimeout() || this.itsInactivityListener == null) continue;
                    this.itsInactivityListener.activateBackupDataSource(fsDataSource2.getReceiveInactivityDataSource());
                    fsDataSource2.setReceiveFailOverState(true);
                }
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Error performing data source inactivity checks: " + exception.getMessage(), exception);
            }
        }
    }

    public List<String> getDataSources(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (fsDataSource fsDataSource2 : this.itsDataSources.values()) {
            if (!fsDataSource2.getProtocol().equalsIgnoreCase(string)) continue;
            arrayList.add(fsDataSource2.getName());
        }
        return arrayList;
    }

    public List<String> getDataSources() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (fsDataSource fsDataSource2 : this.itsDataSources.values()) {
            arrayList.add(fsDataSource2.getName());
        }
        return arrayList;
    }

    public void resetPool() {
        for (fsConnectionFactoryInt fsConnectionFactoryInt2 : this.itsDataSourceFactories.values()) {
            fsConnectionFactoryInt2.resetPool();
        }
    }

    public String getInternalProtocol() {
        fsDataSource fsDataSource2 = null;
        if (this.itsDataSources != null) {
            fsDataSource2 = this.itsDataSources.get(SOURCE_INTERNAL.toUpperCase());
        }
        if (fsDataSource2 != null) {
            return fsDataSource2.getProtocol();
        }
        return PROTOCOL_LOCAL;
    }

    public fsConnectionInt getInternalConnection() {
        fsConnectionFactoryInt fsConnectionFactoryInt2 = this.getDataSourceFactory(this.getInternalProtocol());
        fsConnectionInt fsConnectionInt2 = fsConnectionFactoryInt2.getConnection(SOURCE_INTERNAL);
        return fsConnectionInt2;
    }

    public synchronized void startEventNotificationProviders() throws ApplicationException {
        for (Map.Entry<String, fsEventNotificationInt> entry : this.itsProducers.entrySet()) {
            Util_Logger.info(logger, "Starting [" + entry.getKey() + "] event notification provider with [" + entry.getValue().getListenerCount() + "] listeners");
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            executorService.submit(() -> ((fsEventNotificationInt)entry.getValue()).start());
        }
    }

    public List<fsEventData> getNewFileEvents(String string) throws ApplicationException {
        List<fsEventData> list = null;
        fsEventNotificationInt fsEventNotificationInt2 = this.itsConsumers.get(string);
        if (fsEventNotificationInt2 != null) {
            list = fsEventNotificationInt2.getNewFileEvents(string);
        } else {
            Util_Logger.error(logger, "Unable to find event producer for event consumer [" + string + "]");
        }
        return list;
    }

    public void processedNewFileEvent(String string, List<fsEventData> list) throws ApplicationException {
        fsEventNotificationInt fsEventNotificationInt2 = this.itsConsumers.get(string);
        if (fsEventNotificationInt2 != null) {
            fsEventNotificationInt2.processedNewFileEvent(string, list);
        } else {
            Util_Logger.error(logger, "Unable to find event producer for event consumer [" + string + "]");
        }
    }

    public void registerListener(fsEventListenerInt fsEventListenerInt2) throws ApplicationException {
        try {
            if (fsEventListenerInt2.getDataSourceIsEventBased()) {
                if (Util.isBlank(fsEventListenerInt2.getEventDataSource())) {
                    throw new Exception("Missing event data source for consumer [" + fsEventListenerInt2.getEventConsumerId() + "]");
                }
                fsEventNotificationInt fsEventNotificationInt2 = this.itsProducers.get(fsEventListenerInt2.getEventDataSource().toUpperCase());
                if (fsEventNotificationInt2 == null) {
                    throw new Exception("Invalid event data source [" + fsEventListenerInt2.getEventDataSource() + "] detected");
                }
                fsEventNotificationInt2.registerListener(fsEventListenerInt2);
                this.itsConsumers.put(fsEventListenerInt2.getEventConsumerId(), fsEventNotificationInt2);
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error registering consumer [" + fsEventListenerInt2.getEventConsumerId() + "] to event producer", exception);
        }
    }

    public WebClientAuthInt getWebAuthProvider(String string) {
        String string2;
        WebClientAuthBase webClientAuthBase = null;
        switch (string2 = this.getConfig(string + "_auth_provider", "").toUpperCase()) {
            case "BASIC": {
                WebClientAuthBasic webClientAuthBasic = new WebClientAuthBasic();
                String string3 = this.getConfig(string + "_basic_auth_username", "");
                String string4 = this.getConfig(string + "_basic_auth_password", "");
                webClientAuthBasic.setBasicAuthCredentials(string3, string4);
                webClientAuthBase = webClientAuthBasic;
                break;
            }
            case "APIKEY": {
                WebClientAuthAPIKey webClientAuthAPIKey = new WebClientAuthAPIKey();
                String string5 = this.getConfig(string + "_api_key_name", "");
                String string6 = this.getConfig(string + "_api_key_value", "");
                webClientAuthAPIKey.setAPIKey(string5, string6);
                webClientAuthBase = webClientAuthAPIKey;
                break;
            }
            case "NONE": {
                WebClientAuthNone webClientAuthNone;
                webClientAuthBase = webClientAuthNone = new WebClientAuthNone();
                break;
            }
            default: {
                throw new RuntimeException("Unsupported auth provider [" + string2 + "] for data source " + string);
            }
        }
        return webClientAuthBase;
    }

    private static class SingletonHolder {
        private static FilesystemManager instance = new FilesystemManager();

        private SingletonHolder() {
        }
    }
}

