/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.FileSystem;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.FTP.FtpConnectionPool;
import au.com.aemo.Common.FileSystem.FilesystemManager;
import au.com.aemo.Common.FileSystem.fsConnectionFactoryBase;
import au.com.aemo.Common.FileSystem.fsConnectionFtp;
import au.com.aemo.Common.FileSystem.fsConnectionInt;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class fsConnectionFactoryFtp
extends fsConnectionFactoryBase {
    private static Logger logger = LoggerFactory.getLogger(fsConnectionFactoryFtp.class);
    private Map<String, FtpConnectionPool> itsPools;

    private fsConnectionFactoryFtp() {
        super("FTP");
    }

    public static fsConnectionFactoryFtp getInstance() {
        return SingletonHolder.instance;
    }

    @Override
    public void start() {
        try {
            this.createFtpConnectionPool();
            this.setIsRunning(true);
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error establishing FTP pool: " + exception.getMessage(), exception);
        }
    }

    private void createFtpConnectionPool() throws ApplicationException {
        this.itsPools = new HashMap<String, FtpConnectionPool>();
        FilesystemManager filesystemManager = FilesystemManager.getInstance();
        for (String string : filesystemManager.getDataSources("FTP")) {
            FtpConnectionPool ftpConnectionPool = new FtpConnectionPool(filesystemManager.getConfigPrefix(), string, filesystemManager.getConfiguration(), filesystemManager.getAppName() + " v" + filesystemManager.getAppVersion());
            this.itsPools.put(ftpConnectionPool.getId(), ftpConnectionPool);
            Util_Logger.info(logger, "Created FTP connection pool ID : " + ftpConnectionPool.getId());
        }
    }

    @Override
    public fsConnectionInt getConnection(String string) {
        FtpConnectionPool ftpConnectionPool = this.itsPools.get(Util.noNull(string));
        if (ftpConnectionPool == null) {
            throw new RuntimeException("Unable to borrow FTP connection from pool ID: " + string);
        }
        return new fsConnectionFtp(ftpConnectionPool.getConnection(), string);
    }

    @Override
    public void freeConnection(fsConnectionInt fsConnectionInt2) {
        FtpConnectionPool ftpConnectionPool;
        if (fsConnectionInt2 != null && (ftpConnectionPool = this.itsPools.get(fsConnectionInt2.getDataSourceId())) != null) {
            fsConnectionFtp fsConnectionFtp2 = (fsConnectionFtp)fsConnectionInt2;
            ftpConnectionPool.returnConnection(fsConnectionFtp2.getConnection());
        }
    }

    @Override
    public void resetPool(String string) {
        FtpConnectionPool ftpConnectionPool;
        if (this.itsPools != null && (ftpConnectionPool = this.itsPools.get(string)) != null) {
            ftpConnectionPool.clearCache();
        }
    }

    @Override
    public void resetPool() {
        if (this.itsPools != null) {
            for (FtpConnectionPool ftpConnectionPool : this.itsPools.values()) {
                ftpConnectionPool.clearCache();
            }
        }
    }

    public List<String> getPoolList() {
        if (this.itsPools == null) {
            return null;
        }
        return new ArrayList<String>(this.itsPools.keySet());
    }

    private static class SingletonHolder {
        private static fsConnectionFactoryFtp instance = new fsConnectionFactoryFtp();

        private SingletonHolder() {
        }
    }
}

