/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.FileSystem;

import au.com.aemo.Common.FileSystem.FilesystemManager;
import au.com.aemo.Common.FileSystem.fsConnectionBase;
import au.com.aemo.Common.FileSystem.fsConnectionFileFilterInt;
import au.com.aemo.Common.FileSystem.fsEventData;
import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.FileSystem.fsFileLockInt;
import au.com.aemo.Common.FileSystem.fsFileLockNone;
import au.com.aemo.Common.FileSystem.fsGraphQLConfig;
import au.com.aemo.Common.FileSystem.fsGraphQLDataManager;
import au.com.aemo.Common.FileSystem.fsGraphQLPayload;
import au.com.aemo.Common.Files.FileUtilities;
import au.com.aemo.Common.JSON.JsonOptions;
import au.com.aemo.Common.JSON.JsonUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Web.WebHttpResponse;
import com.google.gson.JsonObject;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class fsConnectionGraphQL
extends fsConnectionBase {
    private static Logger logger = LoggerFactory.getLogger(fsConnectionGraphQL.class);
    private String itsDataSourceId;
    private String itsBaseURL;
    private Proxy itsProxy;
    private int itsTransferBufferSize;
    private int itsTimeoutConnectionSecs;
    private int itsTimeoutTransferSecs;
    private Integer itsURLVersion;
    private int itsMaxProcessAttempts;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Class is consumed by trusted code")
    public fsConnectionGraphQL(String string, String string2, Proxy proxy, int n, int n2, int n3) {
        super(string);
        this.itsDataSourceId = string;
        this.itsBaseURL = string2;
        this.itsProxy = proxy;
        this.itsTransferBufferSize = 1024;
        this.itsTimeoutConnectionSecs = n;
        this.itsTimeoutTransferSecs = n2;
        this.itsMaxProcessAttempts = n3;
        String[] stringArray = Util.getColumns(this.itsBaseURL, '/');
        if (stringArray != null) {
            for (String string3 : stringArray) {
                String string4;
                if (Util.isBlank(string3) || !string3.toLowerCase().startsWith("v") || string3.length() <= 1 || !Util.isInteger(string4 = string3.substring(1))) continue;
                this.itsURLVersion = Integer.parseInt(string4);
            }
        }
    }

    @Override
    public String getDataSourceId() {
        return this.itsDataSourceId;
    }

    protected String getBaseURL() {
        return this.itsBaseURL;
    }

    @Override
    public boolean supportsFileTimestamps() {
        return false;
    }

    @Override
    public boolean supportsFileMasks() {
        return false;
    }

    @Override
    public fsFileInfo resolveFilenameSpec(String string) throws Exception {
        throw new Exception("GraphQL connection does not support a resolveFilenameSpec operation");
    }

    @Override
    public void makeDir(String string) throws Exception {
        throw new Exception("GraphQL connection does not support a directory create operation");
    }

    @Override
    public void changeDir(String string) throws Exception {
    }

    private HttpURLConnection getHttpURLConnection(String string, String string2) {
        HttpURLConnection httpURLConnection = null;
        try {
            byte[] byArray = string2.getBytes(StandardCharsets.UTF_8);
            int n = byArray.length;
            URL uRL = new URL(string);
            httpURLConnection = this.itsProxy == null ? (HttpURLConnection)uRL.openConnection(Proxy.NO_PROXY) : (HttpURLConnection)uRL.openConnection(this.itsProxy);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setAllowUserInteraction(false);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setConnectTimeout(this.itsTimeoutConnectionSecs * 1000);
            httpURLConnection.setReadTimeout(this.itsTimeoutTransferSecs * 1000);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setRequestProperty("Content-Type", "application/json");
            httpURLConnection.setRequestProperty("charset", "utf-8");
            httpURLConnection.setRequestProperty("Content-Length", Integer.toString(n));
            httpURLConnection.connect();
            try (DataOutputStream dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());){
                dataOutputStream.write(byArray);
            }
        }
        catch (Exception exception) {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            httpURLConnection = null;
            Util_Logger.errorNoRaise(logger, "Error connecting to HTTP URL " + string + ": " + exception.getMessage(), exception);
        }
        return httpURLConnection;
    }

    @Override
    public Map<String, fsFileInfo> listFiles(String string, fsConnectionFileFilterInt fsConnectionFileFilterInt2, String string2) throws Exception {
        HashMap<String, fsFileInfo> hashMap = new HashMap<String, fsFileInfo>();
        try {
            List<fsFileInfo> list = null;
            if (!Util.isBlank(string2)) {
                List<fsEventData> list2 = FilesystemManager.getInstance().getNewFileEvents(string2);
                list = fsGraphQLDataManager.getInstance().getNewReportsForEvent(string2, list2, this.itsDataSourceId, this.itsURLVersion, this.itsMaxProcessAttempts);
            } else {
                list = fsGraphQLDataManager.getInstance().getNewReportsPeriodic(this.itsDataSourceId, this.itsURLVersion);
            }
            for (fsFileInfo fsFileInfo2 : list) {
                if (fsFileInfo2.isCompleted() || !fsConnectionFileFilterInt2.accept(fsFileInfo2)) continue;
                hashMap.put(fsFileInfo2.getFilename(), fsFileInfo2);
            }
            Util_Logger.debug(logger, "Detected " + hashMap.size() + " files");
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error listing new content from GraphQL API: " + exception.getMessage(), exception);
        }
        return hashMap;
    }

    @SuppressFBWarnings(value={"DM_STRING_CTOR"}, justification="Avoid holding object reference to string")
    protected WebHttpResponse readData(String string) throws Exception {
        WebHttpResponse webHttpResponse = new WebHttpResponse();
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = this.getHttpURLConnection(this.itsBaseURL, string);
            webHttpResponse.ReturnCode = httpURLConnection.getResponseCode();
            if (!Util.isBlank(httpURLConnection.getContentType())) {
                webHttpResponse.ContentType = new String(httpURLConnection.getContentType());
            }
            if (httpURLConnection.getResponseCode() == 200) {
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));){
                    webHttpResponse.Body = bufferedReader.lines().collect(Collectors.joining("\n"));
                }
            }
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream()));){
                webHttpResponse.Body = bufferedReader.lines().collect(Collectors.joining("\n"));
            }
            if (Util.isBlank(webHttpResponse.Body)) {
                webHttpResponse.Body = httpURLConnection.getResponseMessage();
            }
            httpURLConnection.disconnect();
        }
        catch (Exception exception) {
            try {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Util_Logger.error(logger, "Error reading data from GraphQL: " + exception.getMessage(), exception);
        }
        return webHttpResponse;
    }

    protected byte[] readData(fsFileInfo fsFileInfo2, String string, fsFileLockInt fsFileLockInt2) throws Exception {
        byte[] byArray = null;
        HttpURLConnection httpURLConnection = null;
        try {
            Util_Logger.debug(logger, "GraphQL content request: " + string);
            httpURLConnection = this.getHttpURLConnection(this.itsBaseURL, string);
            if (httpURLConnection.getResponseCode() == 200) {
                try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                    int n = 0;
                    try (InputStream inputStream = httpURLConnection.getInputStream();){
                        int n2;
                        byte[] byArray2 = new byte[this.itsTransferBufferSize];
                        while ((n2 = inputStream.read(byArray2)) != -1) {
                            byteArrayOutputStream.write(byArray2, 0, n2);
                            n += n2;
                        }
                    }
                    byteArrayOutputStream.flush();
                    byArray = byteArrayOutputStream.toByteArray();
                }
            }
            throw new Exception("Rejected GraphQL request, response code = " + httpURLConnection.getResponseCode() + ": " + httpURLConnection.getResponseMessage());
            httpURLConnection.disconnect();
        }
        catch (Exception exception) {
            try {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Util_Logger.error(logger, "Error reading data from GraphQL: " + exception.getMessage(), exception);
        }
        return byArray;
    }

    private String resolveGraphQLQuery(String string) throws Exception {
        int n;
        CharSequence charSequence;
        Object object;
        Pattern pattern = Pattern.compile("\\#(.+?)\\#");
        Matcher matcher = pattern.matcher(string);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (matcher.find()) {
            object = matcher.group(1);
            arrayList.add(object);
        }
        object = new HashMap();
        for (String string2 : arrayList) {
            Util_Logger.debug(logger, "Resolving GraphQL query parameter [" + string2 + "]");
            charSequence = fsGraphQLDataManager.getInstance().buildObjectAttributes(this.getDataSourceId(), string2);
            object.put(string2, ((StringBuilder)charSequence).toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean n2 = false;
        matcher.reset();
        while (matcher.find()) {
            charSequence = matcher.group(1);
            String string2 = (String)object.get(charSequence);
            stringBuilder.append(string.substring(n, matcher.start()));
            if (string2 == null) {
                stringBuilder.append(matcher.group(0));
                System.err.println("Unable to resolve token [" + matcher.group(0) + "] in [" + string + "]");
            } else {
                stringBuilder.append(string2);
            }
            n = matcher.end();
        }
        stringBuilder.append(string.substring(n, string.length()));
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public fsFileInfo getFile(fsFileInfo fsFileInfo2, String string) throws Exception {
        fsFileInfo fsFileInfo3 = null;
        File file = null;
        HttpURLConnection httpURLConnection = null;
        try {
            fsEventData fsEventData2 = fsFileInfo2.getEventData();
            if (fsEventData2 == null) throw new Exception("Detected missing event for GraphQL request");
            fsGraphQLConfig.fsGraphQLReport fsGraphQLReport2 = (fsGraphQLConfig.fsGraphQLReport)fsEventData2.getEventData();
            if (fsGraphQLReport2 == null) throw new Exception("Detected missing report definition for GraphQL request");
            fsGraphQLPayload fsGraphQLPayload2 = new fsGraphQLPayload();
            fsGraphQLPayload2.operationName = fsGraphQLReport2.OperationName;
            fsGraphQLPayload2.query = this.resolveGraphQLQuery(fsGraphQLReport2.Query);
            for (Map.Entry<String, String> entry : fsEventData2.getEventParameters().entrySet()) {
                fsGraphQLPayload2.variables.put(entry.getKey(), entry.getValue());
            }
            String string2 = JsonUtilities.toJson(fsGraphQLPayload2);
            Util_Logger.debug(logger, "GraphQL content request: " + (String)string2);
            httpURLConnection = this.getHttpURLConnection(this.itsBaseURL, string2);
            if (httpURLConnection.getResponseCode() != 200) throw new Exception("Rejected GraphQL request, response code = " + httpURLConnection.getResponseCode() + ": " + httpURLConnection.getResponseMessage());
            file = new File(string + "/" + fsFileInfo2.getFilename());
            try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));){
                StringBuilder stringBuilder = new StringBuilder();
                int n = 0;
                try (Object object = httpURLConnection.getInputStream();){
                    int n2;
                    byte[] byArray = new byte[this.itsTransferBufferSize];
                    while ((n2 = ((InputStream)object).read(byArray)) != -1) {
                        if (Util.isBlank(fsGraphQLReport2.Transform)) {
                            ((OutputStream)bufferedOutputStream).write(byArray, 0, n2);
                        } else {
                            stringBuilder.append(new String(byArray, 0, n2));
                        }
                        n += n2;
                    }
                }
                if (!Util.isBlank(fsGraphQLReport2.Transform)) {
                    object = new JsonUtilities();
                    Util_Logger.debug(logger, "GraphQL JSON raw payload: " + stringBuilder.toString());
                    JsonObject jsonObject = JsonUtilities.getJsonObjectFromString(stringBuilder.toString());
                    Util_Logger.debug(logger, "GraphQL JSON transform: " + fsGraphQLReport2.Transform);
                    JsonObject jsonObject2 = JsonUtilities.getJsonObjectFromString(fsGraphQLReport2.Transform);
                    Util_Logger.debug(logger, "Transforming GraphQL JSON payload");
                    JsonObject jsonObject3 = ((JsonUtilities)object).transformJson(jsonObject, jsonObject2, null);
                    ((OutputStream)bufferedOutputStream).write(JsonUtilities.writeJsonObjectToString(jsonObject3, new JsonOptions()).getBytes());
                    Util_Logger.debug(logger, "Successfully transformed GraphQL JSON payload");
                }
                ((OutputStream)bufferedOutputStream).flush();
            }
            if (fsFileInfo2.getModifiedDate() != null && !file.setLastModified(fsFileInfo2.getModifiedDate().getTime())) {
                Util_Logger.warning(logger, "Unable to set modified time on file [" + file.getName() + "]");
            }
            fsFileInfo3 = new fsFileInfo(fsFileInfo2);
            fsFileInfo3.setDirectory(string);
            return fsFileInfo3;
        }
        catch (Exception exception) {
            try {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                FileUtilities.deleteFile(file);
            }
            catch (Exception exception3) {
                // empty catch block
            }
            Util_Logger.error(logger, "Error transferring file " + fsFileInfo2.getFilename() + " from GraphQL: " + exception.getMessage(), exception);
        }
        return fsFileInfo3;
    }

    @Override
    public void writeData(String string, String string2, byte[] byArray, Date date, fsFileLockInt fsFileLockInt2) throws Exception {
        throw new Exception("GraphQL connection does not support a data write operation");
    }

    @Override
    public void deleteFile(String string, String string2) throws Exception {
    }

    @Override
    public void setBandwidthThrottle(int n) {
    }

    @Override
    public void setTransferBufferSize(int n) {
        this.itsTransferBufferSize = n;
    }

    @Override
    public void disconnect() {
    }

    @Override
    public boolean exists(String string, String string2) {
        return true;
    }

    @Override
    public boolean exists(fsFileInfo fsFileInfo2) throws Exception {
        return this.exists(fsFileInfo2.getDirectory(), fsFileInfo2.getFilename());
    }

    @Override
    public void renameFile(String string, String string2, String string3, String string4) throws Exception {
        throw new Exception("GraphQL connection does not support a file rename operation");
    }

    @Override
    public boolean logOperations() {
        return false;
    }

    @Override
    public fsFileLockInt lockFile(fsFileInfo fsFileInfo2) {
        return new fsFileLockNone();
    }
}

