/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.FileSystem;

import au.com.aemo.Common.FileSystem.FilesystemManager;
import au.com.aemo.Common.FileSystem.fsConnectionAMQP;
import au.com.aemo.Common.FileSystem.fsConnectionFactoryInt;
import au.com.aemo.Common.FileSystem.fsEventNotificationAMQPProcessor;
import au.com.aemo.Common.FileSystem.fsEventNotificationBase;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class fsEventNotificationAMQP
extends fsEventNotificationBase {
    private static Logger logger = LoggerFactory.getLogger(fsEventNotificationAMQP.class);
    private String itsQueueName;
    private String itsConsumerTag;
    private fsConnectionAMQP itsConnection;

    public fsEventNotificationAMQP(String string) {
        super(string);
        this.itsQueueName = FilesystemManager.getInstance().getConfig(string + "_queue_name", null);
        this.itsConsumerTag = this.getEventSourceId() + "-" + this.itsQueueName + "-" + Util.dateToStr(new Date(), "yyyyMMddHHmmssSSSXXX");
    }

    protected Channel getChannel() {
        return this.itsConnection.getChannel();
    }

    protected String getQueueName() {
        return this.itsQueueName;
    }

    @Override
    public void start() {
        Util_Logger.info(logger, "Starting AMQP event notification on queue [" + this.itsQueueName + "]");
        boolean bl = false;
        while (!bl) {
            try {
                fsConnectionFactoryInt fsConnectionFactoryInt2 = FilesystemManager.getInstance().getDataSourceFactory("AMQP");
                this.itsConnection = (fsConnectionAMQP)fsConnectionFactoryInt2.getConnection(this.getEventSourceId());
                boolean bl2 = false;
                Channel channel = this.itsConnection.getChannel();
                channel.basicConsume(this.itsQueueName, bl2, this.itsConsumerTag, (Consumer)new fsEventNotificationAMQPProcessor(this));
                bl = true;
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Error subscribing consumer to AMQP queue [" + this.itsQueueName + "] : " + exception.getMessage(), exception);
                try {
                    Thread.sleep(20000L);
                }
                catch (Exception exception2) {}
            }
        }
    }

    @Override
    public void stop() {
        if (this.itsConnection != null) {
            try {
                fsConnectionFactoryInt fsConnectionFactoryInt2 = FilesystemManager.getInstance().getDataSourceFactory("AMQP");
                fsConnectionFactoryInt2.freeConnection(this.itsConnection);
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Error stopping AMQP event notifications for data source [" + this.getEventSourceId() + "]: " + exception.getMessage(), exception);
            }
        }
    }
}

