/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.JSON;

import au.com.aemo.Common.JSON.JsonExclude;
import au.com.aemo.Common.Java.Util;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

public class JsonOptions {
    private boolean itsPrettyPrint = false;
    private String itsDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSSX";
    private boolean itsApplyExcludeAnnotation = false;

    public JsonOptions setPrettyPrint(boolean bl) {
        this.itsPrettyPrint = bl;
        return this;
    }

    public JsonOptions setDateFormat(String string) {
        this.itsDateFormat = string;
        return this;
    }

    public JsonOptions setApplyExcludeAnnotation(boolean bl) {
        this.itsApplyExcludeAnnotation = bl;
        return this;
    }

    private ExclusionStrategy getExclusionStrategy() {
        ExclusionStrategy exclusionStrategy = new ExclusionStrategy(){

            public boolean shouldSkipClass(Class<?> clazz) {
                return false;
            }

            public boolean shouldSkipField(FieldAttributes fieldAttributes) {
                return fieldAttributes.getAnnotation(JsonExclude.class) != null;
            }
        };
        return exclusionStrategy;
    }

    public Gson getGson() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        if (!Util.isBlank(this.itsDateFormat)) {
            gsonBuilder.setDateFormat(this.itsDateFormat);
        }
        if (this.itsPrettyPrint) {
            gsonBuilder.setPrettyPrinting();
        }
        if (this.itsApplyExcludeAnnotation) {
            gsonBuilder.setExclusionStrategies(new ExclusionStrategy[]{this.getExclusionStrategy()});
        }
        return gsonBuilder.create();
    }
}

