/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Java;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.Application.XProperties;
import au.com.aemo.Common.CSV.Csv;
import au.com.aemo.Common.Logging.Util_Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static Logger logger = LoggerFactory.getLogger(Util.class);
    public static final int boolean_true = 1;
    public static final int boolean_false = 0;
    public static final String EOL = "\r\n";
    public static final String FORMAT_DATE = "dd/MM/yyyy";
    public static final String FORMAT_DATETIME = "dd/MM/yyyy HH:mm:ss";
    public static final String FORMAT_ISO8601 = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";

    public static String replaceFirst(String string, String string2, String string3) {
        if (Util.isBlank(string)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string2.length();
        int n2 = string.indexOf(string2);
        if (n2 != -1) {
            stringBuffer.append(string.substring(0, n2)).append(string3);
            string = string.substring(n2 + n);
        }
        return String.valueOf(stringBuffer.append(string));
    }

    public static String replaceAll(String string, String string2, String string3) {
        int n;
        if (Util.isBlank(string)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string2.length();
        while ((n = string.indexOf(string2)) != -1) {
            stringBuffer.append(string.substring(0, n)).append(string3);
            string = string.substring(n + n2);
        }
        return String.valueOf(stringBuffer.append(string));
    }

    public static boolean wildCardMatch(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        String string3 = string.toLowerCase();
        String string4 = string2.toLowerCase();
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        while (n5 < string4.length()) {
            while (n4 < string3.length()) {
                char c = string3.charAt(n4);
                if (c == '*') {
                    --n5;
                } else if (c == '?') {
                    if (n == 42) {
                        c = '*';
                    }
                } else if (n == 42) {
                    --n5;
                    while (++n5 < string4.length() && c != string4.charAt(n5)) {
                    }
                    n2 = n4;
                    n3 = n5;
                    ++n3;
                } else if (n5 < string4.length()) {
                    if (c != string4.charAt(n5)) {
                        if (n2 >= 0) {
                            n4 = n2;
                            n5 = n3;
                            n = 42;
                            continue;
                        }
                        return false;
                    }
                } else {
                    return false;
                }
                ++n4;
                ++n5;
                n = c;
            }
            if (n5 >= string4.length()) continue;
            if (n == 42) {
                return true;
            }
            if (n2 < 0) {
                return false;
            }
            n4 = n2;
            n5 = n3;
            n = 42;
        }
        return n5 == string4.length();
    }

    public static boolean intToBoolean(int n) {
        return n == 1;
    }

    public static boolean strToBoolean(String string) {
        boolean bl = false;
        if (string != null) {
            switch (string.trim().toUpperCase()) {
                case "TRUE": {
                    bl = true;
                    break;
                }
                case "Y": {
                    bl = true;
                    break;
                }
                case "1": {
                    bl = true;
                    break;
                }
            }
        }
        return bl;
    }

    public static String formatBytes(long l) {
        double d = l;
        DecimalFormat decimalFormat = new DecimalFormat("#,##0.00");
        if (d < 1024.0) {
            return decimalFormat.format(d) + " B";
        }
        if ((d /= 1024.0) < 1024.0) {
            return decimalFormat.format(d) + " kB";
        }
        if ((d /= 1024.0) < 1024.0) {
            return decimalFormat.format(d) + " MB";
        }
        if ((d /= 1024.0) < 1024.0) {
            return decimalFormat.format(d) + " GB";
        }
        return decimalFormat.format(d /= 1024.0) + " TB";
    }

    public static int booleanToInt(boolean bl) {
        if (bl) {
            return 1;
        }
        return 0;
    }

    public static String dateToStr(Date date, String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        simpleDateFormat.setTimeZone(TimeZone.getDefault());
        String string2 = "";
        if (date != null) {
            string2 = simpleDateFormat.format(date);
        }
        return string2;
    }

    public static Date dateTruncateTime(Date date) {
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault());
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date strToDate(String string, String string2) throws ParseException {
        Date date = null;
        if (!Util.isBlank(string)) {
            SimpleDateFormat simpleDateFormat = null;
            simpleDateFormat = string2.length() > string.length() ? new SimpleDateFormat(string2.substring(0, string.length()), Locale.ENGLISH) : new SimpleDateFormat(string2, Locale.ENGLISH);
            simpleDateFormat.setTimeZone(TimeZone.getDefault());
            simpleDateFormat.setLenient(true);
            date = simpleDateFormat.parse(string);
        }
        return date;
    }

    public static Date dateOffset(Date date, int n, int n2) {
        Date date2 = null;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getDefault());
        gregorianCalendar.setTime(date);
        gregorianCalendar.add(n2, n);
        date2 = gregorianCalendar.getTime();
        return date2;
    }

    public static boolean isBlank(String string) {
        boolean bl = true;
        if (string != null && string.trim().length() > 0) {
            bl = false;
        }
        return bl;
    }

    public static String isBlank(String string, String string2) {
        if (Util.isBlank(string)) {
            return string2;
        }
        return string;
    }

    public static String noNull(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"}, justification="Method does not require the return value")
    public static boolean isInteger(String string) {
        boolean bl = false;
        if (string != null) {
            try {
                BigInteger bigInteger = new BigInteger(string);
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"}, justification="Method does not require the return value")
    public static boolean isDouble(String string) {
        boolean bl = false;
        if (string != null) {
            try {
                double d = Double.parseDouble(string);
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    public static boolean isHex(String string) {
        return string.matches("[0-9a-fA-F]+");
    }

    private static String getProperty(Properties properties, String string, boolean bl) throws ApplicationException {
        String string2;
        block4: {
            string2 = "";
            try {
                string2 = properties.getProperty(string);
                if (string2 != null) {
                    string2 = string2.trim();
                }
            }
            catch (Exception exception) {
                if (!bl) break block4;
                Util_Logger.errorNoRaise(logger, "Error property " + string + " : " + exception.getMessage(), exception);
            }
        }
        if (string2 == null && bl) {
            Util_Logger.error(logger, "Error extracting property " + string + ", property value is null", null);
        }
        return string2;
    }

    public static String getProperty(Properties properties, String string) throws ApplicationException {
        try {
            return Util.getProperty(properties, string, true);
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error extracting property " + string + ", property value is null", exception);
            return null;
        }
    }

    public static String getProperty(Properties properties, String string, String string2) {
        String string3 = string2;
        try {
            string3 = Util.getProperty(properties, string, false);
            string3 = Util.isBlank(string3) ? string2 : string3.trim();
        }
        catch (Exception exception) {
            string3 = string2;
        }
        return string3;
    }

    public static Properties getPropertiesObject(String string) throws ApplicationException {
        XProperties xProperties = null;
        try (InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);){
            xProperties = new XProperties();
            xProperties.load(inputStream);
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error reading properties file " + string + ": " + exception.getMessage(), exception);
        }
        return xProperties;
    }

    public static String getProperty(String string, String string2) throws IOException, ApplicationException {
        Properties properties = Util.getPropertiesObject(string);
        return Util.getProperty(properties, string2);
    }

    public static String getProperty(String string, String string2, String string3) {
        try {
            Properties properties = Util.getPropertiesObject(string);
            return Util.getProperty(properties, string2, string3);
        }
        catch (Exception exception) {
            return string3;
        }
    }

    public static String[] getColumns(String string, char c) {
        if (!Util.isBlank(string)) {
            Csv csv = new Csv(c);
            return csv.parse(string);
        }
        return null;
    }

    public static List<String> getList(String string, char c) {
        Csv csv;
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!Util.isBlank(string) && (stringArray = (csv = new Csv(c)).parse(string)) != null) {
            for (String string2 : stringArray) {
                if (Util.isBlank(string2)) continue;
                arrayList.add(string2.trim());
            }
        }
        return arrayList;
    }

    public static String getFileUrl(String string) {
        return Util.replaceAll(string, "\\", "\\\\");
    }

    public static String getUniqueFile(String string, String string2) {
        String string3 = string + "_" + System.currentTimeMillis();
        if (!Util.isBlank(string2)) {
            string3 = string3 + "." + string2;
        }
        return string3;
    }

    public static String readableFileSize(long l) {
        if (l <= 0L) {
            return "0";
        }
        String[] stringArray = new String[]{"B", "kB", "MB", "GB", "TB"};
        int n = (int)(Math.log10(l) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)l / Math.pow(1024.0, n)) + " " + stringArray[n];
    }
}

