/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Web;

import au.com.aemo.Common.Java.ObjectUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Web.WebContent;
import au.com.aemo.Common.Web.WebGET;
import au.com.aemo.Common.Web.WebHandlerAPIWrapperMethod;
import au.com.aemo.Common.Web.WebPOST;
import au.com.aemo.Common.Web.WebParam;
import au.com.aemo.Common.Web.WebParamException;
import au.com.aemo.Common.Web.WebParamValidationConfig;
import au.com.aemo.Common.Web.WebParamValidatorTypeFactory;
import au.com.aemo.Common.Web.WebParamValidatorTypeInt;
import au.com.aemo.Common.Web.WebPath;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebHandlerAPIWrapper {
    private static Logger logger = LoggerFactory.getLogger(WebHandlerAPIWrapper.class);
    protected Class Handler;
    public Field fieldURL;
    public Field fieldParams;
    public Field fieldUUID;
    public Field fieldSessionKey;
    private Map<String, WebHandlerAPIWrapperMethod> getMethods = new HashMap<String, WebHandlerAPIWrapperMethod>();
    private Map<String, WebHandlerAPIWrapperMethod> postMethods = new HashMap<String, WebHandlerAPIWrapperMethod>();

    @SuppressFBWarnings(value={"DM_EXIT"}, justification="Exits if a fatal configuration error is detected")
    public WebHandlerAPIWrapper(Class clazz) {
        Object object;
        String string = "";
        if (clazz.isAnnotationPresent(WebPath.class)) {
            WebPath webPath = clazz.getAnnotation(WebPath.class);
            object = webPath;
            string = object.value();
        }
        boolean bl = true;
        for (Method method : object = clazz.getDeclaredMethods()) {
            WebContent webContent;
            Annotation annotation;
            WebHandlerAPIWrapperMethod webHandlerAPIWrapperMethod = null;
            if (method.isAnnotationPresent(WebGET.class)) {
                Util_Logger.debug(logger, "Detected Web API GET endpoint at method " + method.getName());
                annotation = method.getAnnotation(WebGET.class);
                webHandlerAPIWrapperMethod = new WebHandlerAPIWrapperMethod();
                webHandlerAPIWrapperMethod.auth = annotation.Authentication();
                webHandlerAPIWrapperMethod.AuthContext = annotation.AuthContext();
                webHandlerAPIWrapperMethod.AdminAccessOnly = annotation.AdminAccessOnly();
                webHandlerAPIWrapperMethod.action = annotation.Action();
                webHandlerAPIWrapperMethod.method = method;
                webHandlerAPIWrapperMethod.clazz = clazz;
                webHandlerAPIWrapperMethod.setPath(this.concatPath(string, annotation.Path()));
                if (method.isAnnotationPresent(WebContent.class)) {
                    webContent = method.getAnnotation(WebContent.class);
                    webHandlerAPIWrapperMethod.contentType = webContent.value().toString();
                }
                if (!this.checkMethodParameters(webHandlerAPIWrapperMethod, clazz)) {
                    bl = false;
                }
                if (this.getMethods.put(webHandlerAPIWrapperMethod.path, webHandlerAPIWrapperMethod) != null) {
                    Util_Logger.errorNoRaise(logger, "Detected duplicate GET path " + webHandlerAPIWrapperMethod.path + " in web handler " + clazz.getName());
                }
            }
            if (method.isAnnotationPresent(WebPOST.class)) {
                Util_Logger.debug(logger, "Detected Web API POST endpoint at method " + method.getName());
                annotation = method.getAnnotation(WebPOST.class);
                webHandlerAPIWrapperMethod = new WebHandlerAPIWrapperMethod();
                webHandlerAPIWrapperMethod.setPath(this.concatPath(string, annotation.Path()));
                webHandlerAPIWrapperMethod.auth = annotation.Authentication();
                webHandlerAPIWrapperMethod.AuthContext = annotation.AuthContext();
                webHandlerAPIWrapperMethod.AdminAccessOnly = annotation.AdminAccessOnly();
                webHandlerAPIWrapperMethod.action = annotation.Action();
                webHandlerAPIWrapperMethod.method = method;
                webHandlerAPIWrapperMethod.clazz = clazz;
                if (method.isAnnotationPresent(WebContent.class)) {
                    WebContent webContent2 = webContent = method.getAnnotation(WebContent.class);
                    webHandlerAPIWrapperMethod.contentType = webContent2.value().toString();
                }
                if (!this.checkMethodParameters(webHandlerAPIWrapperMethod, clazz)) {
                    bl = false;
                }
                if (this.postMethods.put(webHandlerAPIWrapperMethod.path, webHandlerAPIWrapperMethod) != null) {
                    Util_Logger.errorNoRaise(logger, "Detected duplicate POST path " + webHandlerAPIWrapperMethod.path + " in web handler " + clazz.getName());
                    bl = false;
                }
            }
            if (webHandlerAPIWrapperMethod == null || webHandlerAPIWrapperMethod.methodParams.size() <= 10) continue;
            Util_Logger.errorNoRaise(logger, "Detected method [" + method.getName() + "] in web handler [" + clazz.getName() + "] exceeds maximum number of parameters [10]. Please update WebHandlerAPI class");
            bl = false;
        }
        if (!bl) {
            Util_Logger.errorNoRaise(logger, "Detected fatal error in web API handler " + clazz.getName() + ", aborting startup");
            System.exit(-1);
        }
        if (this.getMethods.size() > 0 || this.postMethods.size() > 0) {
            List<Field> list = ObjectUtilities.getInheritedPrivateFields(clazz);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Field field = (Field)iterator.next();
                if (field.getName().equalsIgnoreCase("URL")) {
                    if (field.getType().equals(String.class)) {
                        this.fieldURL = field;
                        continue;
                    }
                    Util_Logger.warning(logger, "Detected field URL is class " + field.getType().getName() + " is not assignable from String, skipping URL variable injection");
                    continue;
                }
                if (field.getName().equalsIgnoreCase("Params")) {
                    if (field.getType().equals(Map.class)) {
                        this.fieldParams = field;
                        continue;
                    }
                    Util_Logger.warning(logger, "Detected field Params in class " + field.getType().getName() + " is not assignable from Map, skipping Params variable injection");
                    continue;
                }
                if (field.getName().equalsIgnoreCase("UUID")) {
                    if (field.getType().equals(String.class)) {
                        this.fieldUUID = field;
                        continue;
                    }
                    Util_Logger.warning(logger, "Detected field UUID in class " + field.getType().getName() + " is not assignable from String, skipping UUID variable injection");
                    continue;
                }
                if (!field.getName().equalsIgnoreCase("SessionKey")) continue;
                if (field.getType().equals(String.class)) {
                    this.fieldSessionKey = field;
                    continue;
                }
                Util_Logger.warning(logger, "Detected field SessionKey in class " + field.getType().getName() + " is not assignable from String, skipping SessionKey variable injection");
            }
            this.Handler = clazz;
        } else {
            Util_Logger.errorNoRaise(logger, "Error registering handler " + clazz.getName() + ", no GET or POST methods detected");
        }
    }

    private boolean checkMethodParameters(WebHandlerAPIWrapperMethod webHandlerAPIWrapperMethod, Class clazz) {
        WebParamValidatorTypeFactory webParamValidatorTypeFactory = WebParamValidatorTypeFactory.getInstance();
        boolean bl = true;
        Method method = webHandlerAPIWrapperMethod.method;
        Class<?>[] classArray = method.getParameterTypes();
        int n = 0;
        for (Parameter parameter : method.getParameters()) {
            Object object;
            WebParamValidationConfig webParamValidationConfig = new WebParamValidationConfig(parameter.getName(), classArray[n]);
            if (parameter.isAnnotationPresent(WebParam.class)) {
                object = parameter.getAnnotation(WebParam.class);
                if ((webParamValidationConfig = webParamValidationConfig.setSource(object.source()).setMandatory(object.mandatory()).setDefaultValue(object.defaultValue()).setValidatorParam(object.validatorParam()).setRegex(object.regex()).setValidator(object.validator())).getType().isPrimitive() && Util.isBlank(webParamValidationConfig.getDefaultValue()) && !webParamValidationConfig.isMandatory()) {
                    Util_Logger.errorNoRaise(logger, "Detected missing DefaultValue in WebParam annotation in method [" + method.getName() + "] for optional primitive parameter [" + parameter.getName() + "] in web handler " + clazz.getName());
                    bl = false;
                }
            } else {
                Util_Logger.errorNoRaise(logger, "Detected missing WebParam annotation in method [" + method.getName() + "] for parameter [" + parameter.getName() + "] in web handler " + clazz.getName());
                bl = false;
            }
            try {
                object = webParamValidationConfig.getValidator();
                if (object == null) {
                    object = webParamValidatorTypeFactory.getValidator(webParamValidationConfig.getType().getName());
                }
                if (object != null) {
                    if (object instanceof WebParamValidatorTypeInt) {
                        try {
                            object.validate("1", webParamValidationConfig);
                        }
                        catch (WebParamException webParamException) {
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            Util_Logger.errorNoRaise(logger, "Detected missing validator implementation [" + webParamValidationConfig.getValidatorParam().name() + "] for java type [" + webParamValidationConfig.getType().getName() + "] in web handler " + clazz.getName() + "." + method.getName(), illegalArgumentException);
                            bl = false;
                        }
                    } else {
                        Util_Logger.errorNoRaise(logger, "Detected invalidator class in method [" + method.getName() + "] for parameter [" + parameter.getName() + "] with java type [" + String.valueOf(webParamValidationConfig.getValidator().getClass()) + "] in web handler " + clazz.getName());
                        bl = false;
                    }
                } else {
                    Util_Logger.errorNoRaise(logger, "Detected missing validator in method [" + method.getName() + "] for parameter [" + parameter.getName() + "] with java type [" + webParamValidationConfig.getType().getName() + "] in web handler " + clazz.getName());
                    bl = false;
                }
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Detected error in validator constructor implementation [" + webParamValidationConfig.getValidatorParam().name() + "] for java type [" + webParamValidationConfig.getType().getName() + "]", exception);
                bl = false;
            }
            webHandlerAPIWrapperMethod.methodParams.add(webParamValidationConfig);
            ++n;
        }
        return bl;
    }

    private String concatPath(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!Util.isBlank(string)) {
            stringBuilder.append(string);
        }
        if (!Util.isBlank(string2)) {
            if (stringBuilder.length() > 0 && !string.endsWith("/") && !string2.startsWith("/")) {
                stringBuilder.append("/");
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public List<WebHandlerAPIWrapperMethod> getMethods(String string) {
        if (string.equalsIgnoreCase("GET")) {
            return new ArrayList<WebHandlerAPIWrapperMethod>(this.getMethods.values());
        }
        if (string.equalsIgnoreCase("POST")) {
            return new ArrayList<WebHandlerAPIWrapperMethod>(this.postMethods.values());
        }
        return null;
    }
}

