/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.izpack.install;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.PanelActionConfiguration;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.data.PanelAction;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class checkIfFilesExist
implements PanelAction {
    private static final Logger logger = Logger.getLogger(checkIfFilesExist.class.getName());
    private List<String> filesToCheck = new ArrayList<String>();
    private String varName;

    @Override
    public void initialize(PanelActionConfiguration panelActionConfiguration) {
        logger.log(Level.CONFIG, "checkIfFilesExist: Initializing.");
        if (panelActionConfiguration == null) {
            logger.log(Level.CONFIG, "checkIfFilesExist: Initialization failed.");
        } else {
            this.varName = panelActionConfiguration.getProperty("varName", null);
            String string = "ZZ";
            int n = 1;
            while (string != null) {
                string = panelActionConfiguration.getProperty("fileCheck" + n, null);
                if (string != null) {
                    this.filesToCheck.add(string);
                    logger.log(Level.CONFIG, "checkIfFilesExist: Added file check for " + string);
                }
                ++n;
            }
            logger.log(Level.CONFIG, "checkIfFilesExist: Initialization variable filesToCheck count = " + this.filesToCheck.size());
        }
    }

    @Override
    public void executeAction(InstallData installData, AbstractUIHandler abstractUIHandler) {
        logger.log(Level.CONFIG, "checkIfFilesExist: Starting");
        String string = installData.getInstallPath();
        boolean bl = false;
        if (this.filesToCheck.size() > 0) {
            bl = true;
            for (String string2 : this.filesToCheck) {
                logger.log(Level.CONFIG, "checkIfFilesExist: Validating existance of " + string2);
                File file = new File(string, string2);
                if (file.exists()) continue;
                bl = false;
                logger.log(Level.CONFIG, "checkIfFilesExist: Detected " + string2 + " is missing from install, IS_UPGRADE = false");
                break;
            }
        }
        if (this.varName != null) {
            installData.setVariable(this.varName, bl ? "Y" : "N");
        } else {
            logger.log(Level.CONFIG, "checkIfFilesExist: Unable to set upgrade variable as varName is not defined");
        }
        logger.log(Level.CONFIG, "checkIfFilesExist: Completed");
    }
}

