/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.izpack.install;

import au.com.aemo.Common.Authentication.KeyManager;
import au.com.aemo.izpack.install.UIProcessHandlerWithLogging;
import au.com.aemo.izpack.install.automatedInstallDataManager;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.PanelActionConfiguration;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.data.PanelAction;
import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class encryptionKeyGenerate
implements PanelAction {
    private static final Logger logger = Logger.getLogger(encryptionKeyGenerate.class.getName());
    private String propertyName1 = null;
    private String propertyName2 = null;
    private String propertyName3 = null;
    private int NoBits = 0;

    @Override
    public void initialize(PanelActionConfiguration panelActionConfiguration) {
        logger.log(Level.CONFIG, "encryptionKeyGenerate: Initializing.");
        if (panelActionConfiguration == null) {
            logger.log(Level.CONFIG, "encryptionKeyGenerate: Initialization failed.");
        } else {
            this.propertyName1 = panelActionConfiguration.getProperty("VariableName1", null);
            logger.log(Level.CONFIG, "encryptionKeyGenerate: Initialization variable " + this.propertyName1);
            this.propertyName2 = panelActionConfiguration.getProperty("VariableName2", null);
            logger.log(Level.CONFIG, "encryptionKeyGenerate: Initialization variable " + this.propertyName2);
            this.propertyName3 = panelActionConfiguration.getProperty("VariableName3", null);
            logger.log(Level.CONFIG, "encryptionKeyGenerate: Initialization variable " + this.propertyName3);
            this.NoBits = Integer.parseInt(panelActionConfiguration.getProperty("NoBits", "64"));
            logger.log(Level.CONFIG, "encryptionKeyGenerate: Initialization variable " + this.NoBits);
        }
    }

    @Override
    public void executeAction(InstallData installData, AbstractUIHandler abstractUIHandler) {
        logger.log(Level.CONFIG, "encryptionKeyGenerate: Starting");
        String string = KeyManager.generateKey(this.NoBits);
        logger.log(Level.CONFIG, "encryptionKeyGenerate: " + string);
        if (this.propertyName1 != null) {
            installData.setVariable(this.propertyName1, string);
        }
        if (this.propertyName2 != null) {
            installData.setVariable(this.propertyName2, string);
        }
        if (this.propertyName3 != null) {
            installData.setVariable(this.propertyName3, string);
        }
        logger.log(Level.CONFIG, "encryptionKeyGenerate: Completed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run(AbstractUIProcessHandler abstractUIProcessHandler, String[] stringArray) {
        boolean bl = false;
        UIProcessHandlerWithLogging uIProcessHandlerWithLogging = new UIProcessHandlerWithLogging(abstractUIProcessHandler, logger);
        try {
            uIProcessHandlerWithLogging.startProcess("Encryption key generator");
            this.NoBits = Integer.parseInt(stringArray[0]);
            String string = KeyManager.generateKey(this.NoBits);
            uIProcessHandlerWithLogging.logOutput("Password encryption key is: " + string, false);
            automatedInstallDataManager automatedInstallDataManager2 = automatedInstallDataManager.getInstance();
            for (int i = 1; i < stringArray.length; ++i) {
                automatedInstallDataManager2.setVariable(stringArray[i], string);
            }
            bl = true;
        }
        catch (Exception exception) {
            uIProcessHandlerWithLogging.logOutput("Error generating encryption key: " + exception.getMessage(), exception);
        }
        finally {
            uIProcessHandlerWithLogging.finishProcess();
        }
        return bl;
    }
}

