/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.izpack.install;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.PanelActionConfiguration;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.core.substitutor.VariableSubstitutorImpl;
import com.izforge.izpack.data.PanelAction;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class xmlFileExtractVariable
implements PanelAction {
    private String inputFile;
    private Map<String, String> mergeFields = new HashMap<String, String>();

    @Override
    public void initialize(PanelActionConfiguration panelActionConfiguration) {
        for (Map.Entry<String, String> entry : panelActionConfiguration.getProperties().entrySet()) {
            if (entry.getKey().equalsIgnoreCase("config_file_backup")) {
                this.inputFile = entry.getValue();
                continue;
            }
            this.mergeFields.put(entry.getKey(), entry.getValue());
        }
    }

    private Document loadFile(String string) throws Exception {
        File file = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            file = new File(string);
            if (file.exists()) {
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                document = documentBuilder.parse(file);
                document.getDocumentElement().normalize();
                XPath xPath = XPathFactory.newInstance().newXPath();
                NodeList nodeList = (NodeList)xPath.evaluate("//text()[normalize-space()='']", document, XPathConstants.NODESET);
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    node.getParentNode().removeChild(node);
                }
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            file = null;
        }
        return document;
    }

    private String getValue(Document document, String string) throws Exception {
        String string2 = null;
        XPath xPath = XPathFactory.newInstance().newXPath();
        Node node = ((NodeList)xPath.compile(string).evaluate(document, XPathConstants.NODESET)).item(0);
        if (node != null) {
            string2 = node.getNodeValue();
        }
        return string2;
    }

    @Override
    public void executeAction(InstallData installData, AbstractUIHandler abstractUIHandler) {
        try {
            VariableSubstitutorImpl variableSubstitutorImpl = new VariableSubstitutorImpl(installData.getVariables());
            String string = variableSubstitutorImpl.substitute(this.inputFile);
            Document document = this.loadFile(string);
            if (document != null) {
                for (Map.Entry<String, String> entry : this.mergeFields.entrySet()) {
                    String string2 = entry.getKey();
                    String string3 = entry.getValue();
                    String string4 = this.getValue(document, string3);
                    if (string4 == null) continue;
                    installData.setVariable(string2, string4);
                }
            }
        }
        catch (Exception exception) {
            abstractUIHandler.emitError("Config Error", "Error restoring previous configuration from " + this.inputFile + ": " + exception.getMessage());
        }
    }
}

