/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Monitor.API;

import au.com.aemo.Common.Authentication.AuthorisationActionEnum;
import au.com.aemo.Common.Database.DbManager;
import au.com.aemo.Common.JSON.JsonUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Web.WebAPIBaseClass;
import au.com.aemo.Common.Web.WebContent;
import au.com.aemo.Common.Web.WebGET;
import au.com.aemo.Common.Web.WebParam;
import au.com.aemo.Common.Web.WebParamValidationEnum;
import au.com.aemo.Common.Web.WebPath;
import au.com.nemmco.Pdr.Common.Monitor.pdrPerformanceRec;
import au.com.nemmco.Pdr.Monitor.API.PerformanceHelperApplication;
import au.com.nemmco.Pdr.Monitor.API.getPerfDataAggregate;
import au.com.nemmco.Pdr.Monitor.API.getPerfDataRaw;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorConfigManager;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorSource;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.util.Date;
import java.util.List;

@WebPath(value="/api/system/${system}/${application}/${instanceId}/performancedetail")
public class WebAPIApplicationPerformanceDetail
extends WebAPIBaseClass {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WebGET(AuthContext="system", Action=AuthorisationActionEnum.READ)
    @WebContent(value=WebContent.MediaType.APPLICATION_JSON)
    public String getApplicationPerformanceDetail(@WebParam(source="system", mandatory=true, validatorParam=WebParamValidationEnum.STR_OBJECT_ID) String string, @WebParam(source="application", mandatory=true, validatorParam=WebParamValidationEnum.STR_OBJECT_ID) String string2, @WebParam(source="instanceId", mandatory=true, validatorParam=WebParamValidationEnum.STR_OBJECT_ID) String string3, @WebParam(source="installationId", mandatory=false, validatorParam=WebParamValidationEnum.POSITIVE) Integer n) throws Exception {
        String string4 = null;
        PerformanceHelperApplication performanceHelperApplication = new PerformanceHelperApplication(this);
        Date date = performanceHelperApplication.startDateTime;
        Date date2 = performanceHelperApplication.endDateTime;
        if (performanceHelperApplication.clickDateTime != null) {
            date = Util.dateOffset(performanceHelperApplication.clickDateTime, -performanceHelperApplication.reportingInterval, 12);
            date2 = performanceHelperApplication.clickDateTime;
        }
        pdrMonitorConfigManager pdrMonitorConfigManager2 = pdrMonitorConfigManager.getInstance();
        List<pdrMonitorSource> list = pdrMonitorConfigManager2.getSources(string, string2, string3, n);
        Connection connection = null;
        try {
            Object object;
            connection = DbManager.getDbConnection();
            List<pdrPerformanceRec> list2 = null;
            if (performanceHelperApplication.aggregatedData) {
                object = new getPerfDataAggregate();
                list2 = ((getPerfDataAggregate)object).loadData(connection, list, date, date2, performanceHelperApplication.reportingInterval, performanceHelperApplication.fileIDList, performanceHelperApplication.dataSource);
            } else {
                object = new getPerfDataRaw();
                list2 = ((getPerfDataRaw)object).loadData(connection, list, date, date2, performanceHelperApplication.fileIDList, performanceHelperApplication.filename, performanceHelperApplication.jobType, performanceHelperApplication.dataSource);
            }
            object = new perfDrillDown();
            ((perfDrillDown)object).isAggregated = performanceHelperApplication.aggregatedData;
            ((perfDrillDown)object).perfData = list2;
            string4 = JsonUtilities.toJson(object);
        }
        finally {
            DbManager.freeDbConnection(connection);
        }
        return string4;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD", "SIC_INNER_SHOULD_BE_STATIC"})
    private class perfDrillDown {
        public boolean isAggregated;
        public List<pdrPerformanceRec> perfData;

        private perfDrillDown() {
        }
    }
}

