/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Monitor.API;

import au.com.aemo.Common.Authentication.AuthorisationActionEnum;
import au.com.aemo.Common.Database.DbManager;
import au.com.aemo.Common.JSON.JsonUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Web.WebAPIBaseClass;
import au.com.aemo.Common.Web.WebContent;
import au.com.aemo.Common.Web.WebGET;
import au.com.aemo.Common.Web.WebParam;
import au.com.aemo.Common.Web.WebParamValidationEnum;
import au.com.aemo.Common.Web.WebPath;
import au.com.nemmco.Pdr.Common.Monitor.pdrPerformanceRec;
import au.com.nemmco.Pdr.Monitor.API.PerformanceHelperApplication;
import au.com.nemmco.Pdr.Monitor.API.getPerfDataRaw;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorConfigManager;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorSource;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

@WebPath(value="/api/system/${system}/${application}/${instanceId}/throughput")
public class WebAPIApplicationThroughput
extends WebAPIBaseClass {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @WebGET(AuthContext="system", Action=AuthorisationActionEnum.READ)
    @WebContent(value=WebContent.MediaType.APPLICATION_JSON)
    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"}, justification="apc object properties are consumed")
    public String getApplicationThroughput(@WebParam(source="system", mandatory=true, validatorParam=WebParamValidationEnum.STR_OBJECT_ID) String string, @WebParam(source="application", mandatory=true, validatorParam=WebParamValidationEnum.STR_OBJECT_ID) String string2, @WebParam(source="instanceId", mandatory=true, validatorParam=WebParamValidationEnum.STR_OBJECT_ID) String string3, @WebParam(source="installationId", mandatory=false, validatorParam=WebParamValidationEnum.POSITIVE) Integer n) throws Exception {
        String string4 = null;
        PerformanceHelperApplication performanceHelperApplication = new PerformanceHelperApplication(this);
        pdrMonitorConfigManager pdrMonitorConfigManager2 = pdrMonitorConfigManager.getInstance();
        List<pdrMonitorSource> list = pdrMonitorConfigManager2.getSources(string, string2, string3, n);
        Connection connection = null;
        try {
            double d;
            throughputSummaryRec throughputSummaryRec4;
            Object object;
            void var17_19;
            Object object22;
            Object object3;
            connection = DbManager.getDbConnection();
            getPerfDataRaw getPerfDataRaw2 = new getPerfDataRaw();
            List<pdrPerformanceRec> list2 = getPerfDataRaw2.loadData(connection, list, performanceHelperApplication.startDateTime, performanceHelperApplication.endDateTime, performanceHelperApplication.fileIDList, performanceHelperApplication.filename, performanceHelperApplication.jobType, performanceHelperApplication.dataSource);
            HashMap<Date, Object> hashMap = new HashMap<Date, Object>();
            int n2 = 0;
            ArrayList<pdrPerformanceRec> arrayList = new ArrayList<pdrPerformanceRec>();
            Date date = null;
            for (pdrPerformanceRec object42 : list2) {
                if (object42.getStartDate() != null && object42.getEndDate() != null && object42.getJobSize() > 0L) {
                    if (object42.getStartDate().before(object42.getEndDate())) {
                        if (!hashMap.containsKey(object42.getStartDate())) {
                            object3 = new throughputSummaryRec();
                            ((throughputSummaryRec)object3).StartDateTime = object42.getStartDate();
                            hashMap.put(((throughputSummaryRec)object3).StartDateTime, object3);
                        }
                        if (((Date)(object3 = Util.dateOffset(object42.getEndDate(), 1, 14))).before(performanceHelperApplication.endDateTime) && !hashMap.containsKey(object3)) {
                            object22 = new throughputSummaryRec();
                            ((throughputSummaryRec)object22).StartDateTime = object3;
                            hashMap.put(((throughputSummaryRec)object22).StartDateTime, object22);
                        }
                        if (date == null) {
                            date = object42.getEndDate();
                        } else if (object42.getEndDate().after(date)) {
                            date = object42.getEndDate();
                        }
                        arrayList.add(object42);
                        continue;
                    }
                    ++n2;
                    continue;
                }
                ++n2;
            }
            ArrayList arrayList2 = new ArrayList(hashMap.values());
            Collections.sort(arrayList2, (throughputSummaryRec2, throughputSummaryRec3) -> throughputSummaryRec2.StartDateTime.compareTo(throughputSummaryRec3.StartDateTime));
            Object var17_18 = null;
            object3 = arrayList2.iterator();
            while (object3.hasNext()) {
                object22 = (throughputSummaryRec)object3.next();
                if (var17_19 != null) {
                    var17_19.EndDateTime = Util.dateOffset(((throughputSummaryRec)object22).StartDateTime, -1, 14);
                }
                throughputSummaryRec throughputSummaryRec5 = object22;
            }
            if (var17_19 != null) {
                var17_19.EndDateTime = date.before(performanceHelperApplication.endDateTime) ? date : performanceHelperApplication.endDateTime;
            }
            for (Object object22 : arrayList) {
                object = arrayList2.iterator();
                while (object.hasNext()) {
                    throughputSummaryRec4 = (throughputSummaryRec)object.next();
                    d = ((pdrPerformanceRec)object22).getEndDate().getTime() - ((pdrPerformanceRec)object22).getStartDate().getTime() + 1L;
                    long l = Math.max(throughputSummaryRec4.StartDateTime.getTime(), ((pdrPerformanceRec)object22).getStartDate().getTime());
                    long l2 = Math.min(throughputSummaryRec4.EndDateTime.getTime(), ((pdrPerformanceRec)object22).getEndDate().getTime());
                    long l3 = l2 - l + 1L;
                    if (l3 <= 0L) continue;
                    double d2 = (double)((pdrPerformanceRec)object22).getJobSize() * (double)l3 / d;
                    throughputSummaryRec4.TotalJobSize += d2;
                    ++throughputSummaryRec4.NoActiveJobs;
                }
            }
            double d3 = 0.0;
            object = arrayList2.iterator();
            while (object.hasNext()) {
                throughputSummaryRec4 = (throughputSummaryRec)object.next();
                if (throughputSummaryRec4.TotalJobSize > 0.0) {
                    d = (double)(throughputSummaryRec4.EndDateTime.getTime() - throughputSummaryRec4.StartDateTime.getTime() + 1L) / 1000.0;
                    throughputSummaryRec4.ThroughPut = throughputSummaryRec4.TotalJobSize / d;
                    d3 += throughputSummaryRec4.TotalJobSize;
                }
                throughputSummaryRec4.CumulativeJobSize = d3;
            }
            object = new throughputSummaryReport();
            ((throughputSummaryReport)object).StartDateTime = performanceHelperApplication.startDateTime;
            ((throughputSummaryReport)object).EndDateTime = performanceHelperApplication.endDateTime;
            ((throughputSummaryReport)object).IgnoredRecords = n2;
            ((throughputSummaryReport)object).ThroughputData = arrayList2;
            string4 = JsonUtilities.toJson(object);
        }
        finally {
            DbManager.freeDbConnection(connection);
        }
        return string4;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD", "SIC_INNER_SHOULD_BE_STATIC"})
    private class throughputSummaryRec {
        public Date StartDateTime;
        public Date EndDateTime;
        public int NoActiveJobs;
        public double TotalJobSize;
        public double ThroughPut;
        public double CumulativeJobSize;

        private throughputSummaryRec() {
        }
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD", "SIC_INNER_SHOULD_BE_STATIC"})
    private class throughputSummaryReport {
        public Date StartDateTime;
        public Date EndDateTime;
        public int IgnoredRecords;
        public List<throughputSummaryRec> ThroughputData = new ArrayList<throughputSummaryRec>();

        private throughputSummaryReport() {
        }
    }
}

