/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Monitor.API;

import au.com.aemo.Common.Authentication.AuthorisationActionEnum;
import au.com.aemo.Common.Database.DbManager;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Web.WebAPIBaseClass;
import au.com.aemo.Common.Web.WebContent;
import au.com.aemo.Common.Web.WebGET;
import au.com.aemo.Common.Web.WebParam;
import au.com.aemo.Common.Web.WebParamValidationEnum;
import au.com.aemo.Common.Web.WebPath;
import au.com.nemmco.Pdr.Monitor.API.PerformanceHelperDataInterchange;
import au.com.nemmco.Pdr.Monitor.API.dataInterchangePerformanceSummaryRec;
import au.com.nemmco.Pdr.Monitor.API.getDIPerfDataStats;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorConfigManager;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorSource;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.util.List;

@WebPath(value="/api/system/${system}/data_interchange/performanceSummary")
public class WebAPIDataInterchangePerformanceSummary
extends WebAPIBaseClass {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WebGET(AuthContext="system", Action=AuthorisationActionEnum.READ)
    @WebContent(value=WebContent.MediaType.TEXT_CSV)
    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"}, justification="diph object properties are consumed")
    public String getDataInterchangePerformanceSummary(@WebParam(source="system", mandatory=true, validatorParam=WebParamValidationEnum.STR_OBJECT_ID) String string) throws Exception {
        String string2 = null;
        PerformanceHelperDataInterchange performanceHelperDataInterchange = new PerformanceHelperDataInterchange(this);
        pdrMonitorConfigManager pdrMonitorConfigManager2 = pdrMonitorConfigManager.getInstance();
        List<pdrMonitorSource> list = pdrMonitorConfigManager2.getSources(string, "pdrLoader", performanceHelperDataInterchange.pdrLoaderInstance, performanceHelperDataInterchange.pdrLoaderInstallationId);
        Connection connection = null;
        try {
            connection = DbManager.getDbConnection();
            getDIPerfDataStats getDIPerfDataStats2 = new getDIPerfDataStats();
            List<dataInterchangePerformanceSummaryRec> list2 = getDIPerfDataStats2.loadData(connection, list, performanceHelperDataInterchange.fileIDList, performanceHelperDataInterchange.startDateTime, performanceHelperDataInterchange.endDateTime, performanceHelperDataInterchange.reportingInterval);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Date,Replication_Min,Replication_Avg,Replication_Max");
            stringBuilder.append("\r\n");
            for (dataInterchangePerformanceSummaryRec dataInterchangePerformanceSummaryRec2 : list2) {
                if (performanceHelperDataInterchange.reportingInterval == 1440) {
                    stringBuilder.append(Util.dateToStr(Util.dateOffset(dataInterchangePerformanceSummaryRec2.PeriodEnding, -1, 5), "yyyy-MM-dd HH:mm:ss"));
                } else {
                    stringBuilder.append(Util.dateToStr(dataInterchangePerformanceSummaryRec2.PeriodEnding, "yyyy-MM-dd HH:mm:ss"));
                }
                stringBuilder.append(",");
                stringBuilder.append(dataInterchangePerformanceSummaryRec2.ReplicationMin);
                stringBuilder.append(",");
                stringBuilder.append(dataInterchangePerformanceSummaryRec2.ReplicationAvg);
                stringBuilder.append(",");
                stringBuilder.append(dataInterchangePerformanceSummaryRec2.ReplicationMax);
                stringBuilder.append("\r\n");
            }
            string2 = stringBuilder.toString();
        }
        finally {
            DbManager.freeDbConnection(connection);
        }
        return string2;
    }
}

