/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Monitor.API;

import au.com.aemo.Common.Authentication.AuthorisationActionEnum;
import au.com.aemo.Common.Database.DbManager;
import au.com.aemo.Common.JSON.JsonUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Web.WebContent;
import au.com.aemo.Common.Web.WebGET;
import au.com.aemo.Common.Web.WebParam;
import au.com.aemo.Common.Web.WebParamValidationEnum;
import au.com.aemo.Common.Web.WebPath;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorConfigManager;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorSource;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@WebPath(value="/api/system/${system}/marketnet/performance")
public class WebAPIMarketnetStatus {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WebGET(AuthContext="system", Action=AuthorisationActionEnum.READ)
    @WebContent(value=WebContent.MediaType.APPLICATION_JSON)
    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE", "SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"})
    public String getMarketnetStatus(@WebParam(source="system", mandatory=true, validatorParam=WebParamValidationEnum.STR_OBJECT_ID) String string, @WebParam(source="pdrBatcher", mandatory=true, validatorParam=WebParamValidationEnum.STR_OBJECT_ID) String string2, @WebParam(source="pdrBatcherInstallationId", mandatory=false, validatorParam=WebParamValidationEnum.POSITIVE) Integer n) throws Exception {
        Connection connection;
        List<Object> list;
        block7: {
            list = new ArrayList();
            pdrMonitorConfigManager pdrMonitorConfigManager2 = pdrMonitorConfigManager.getInstance();
            List<pdrMonitorSource> list2 = pdrMonitorConfigManager2.getSources(string, "pdrBatcher", string2, n);
            connection = null;
            try {
                int n2 = pdrMonitorConfigManager2.getConfig().Monitor.DataInterchange.MarketnetTimeoutMins;
                connection = DbManager.getDbConnection();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("select p.FILE_ID, max(p.END_DATE) as LAST_HEARTBEAT from PDR_MONITOR_PERFORMANCE p");
                stringBuilder.append(" where p.PDR_MONITOR_ID in (");
                String string3 = "";
                for (pdrMonitorSource object2 : list2) {
                    stringBuilder.append(string3);
                    stringBuilder.append(object2.pdr_monitor_id);
                    string3 = ",";
                }
                stringBuilder.append(") and p.START_DATE > ");
                Date date = Util.dateOffset(new Date(), -5 * n2, 12);
                stringBuilder.append(DbManager.getDbHandler().getSqlDate(date));
                stringBuilder.append(" and p.FILE_ID like '%HEARTBEAT%'");
                stringBuilder.append(" and p.PROCESS_ELEMENT_PARENT_ID is NULL");
                stringBuilder.append(" group by p.FILE_ID");
                list = DbManager.selectObjects(connection, stringBuilder.toString(), resultSet -> {
                    MarketnetStatus marketnetStatus = new MarketnetStatus();
                    marketnetStatus.FileId = resultSet.getString("FILE_ID");
                    marketnetStatus.LastHeartbeat = resultSet.getTimestamp("LAST_HEARTBEAT");
                    return marketnetStatus;
                });
                if (list.size() > 0) {
                    Date date2 = Util.dateOffset(new Date(), -n2, 12);
                    for (MarketnetStatus marketnetStatus : list) {
                        if (marketnetStatus.LastHeartbeat == null) {
                            marketnetStatus.Status = "ALERT";
                            continue;
                        }
                        if (marketnetStatus.LastHeartbeat.before(date2)) {
                            marketnetStatus.Status = "ALERT";
                            continue;
                        }
                        marketnetStatus.Status = "OK";
                    }
                    break block7;
                }
                MarketnetStatus marketnetStatus = new MarketnetStatus();
                marketnetStatus.FileId = "HEARTBEAT";
                marketnetStatus.Status = "ALERT";
                list.add(marketnetStatus);
            }
            catch (Throwable throwable) {
                DbManager.freeDbConnection(connection);
                throw throwable;
            }
        }
        DbManager.freeDbConnection(connection);
        return JsonUtilities.listToJson(list);
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD", "SIC_INNER_SHOULD_BE_STATIC"})
    private class MarketnetStatus {
        public String FileId;
        public Date LastHeartbeat;
        public String Status;

        private MarketnetStatus() {
        }
    }
}

