/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Monitor.API;

import au.com.aemo.Common.Authentication.AuthorisationActionEnum;
import au.com.aemo.Common.JSON.JsonUtilities;
import au.com.aemo.Common.Web.WebContent;
import au.com.aemo.Common.Web.WebGET;
import au.com.aemo.Common.Web.WebPOST;
import au.com.aemo.Common.Web.WebParam;
import au.com.aemo.Common.Web.WebParamValidatorTypeJSON;
import au.com.aemo.Common.Web.WebPath;
import au.com.nemmco.Pdr.Common.Monitor.pdrLoggerRec;
import au.com.nemmco.Pdr.Common.Monitor.pdrLoggerRecAck;
import au.com.nemmco.Pdr.Common.Monitor.pdrMonitorManager;
import au.com.nemmco.Pdr.Common.Monitor.pdrMonitorRec;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@WebPath(value="/api/monitorstatus")
public class WebAPIMonitorStatus {
    @WebGET(Action=AuthorisationActionEnum.READ, Path="summary")
    @WebContent(value=WebContent.MediaType.APPLICATION_JSON)
    public String getMonitorStatus() throws Exception {
        MonitorStatus monitorStatus = new MonitorStatus();
        monitorStatus.StatusDate = new Date();
        pdrMonitorManager pdrMonitorManager2 = pdrMonitorManager.getInstance();
        if (pdrMonitorManager2.getCurrentLogRecs() != null) {
            ArrayList<pdrMonitorRec> arrayList = new ArrayList<pdrMonitorRec>(pdrMonitorManager2.getCurrentLogRecs());
            for (pdrLoggerRec pdrLoggerRec2 : arrayList) {
                if (pdrLoggerRec2.getLevel() == null) continue;
                if (pdrLoggerRec2.getLevel().equalsIgnoreCase("INFO")) {
                    if (monitorStatus.LastInfo == null) {
                        monitorStatus.LastInfo = pdrLoggerRec2.getEventDate();
                    } else if (pdrLoggerRec2.getEventDate().after(monitorStatus.LastInfo)) {
                        monitorStatus.LastInfo = pdrLoggerRec2.getEventDate();
                    }
                    ++monitorStatus.InfoCount;
                    continue;
                }
                if (pdrLoggerRec2.getLevel().equalsIgnoreCase("WARNING")) {
                    if (monitorStatus.LastWarning == null) {
                        monitorStatus.LastWarning = pdrLoggerRec2.getEventDate();
                    } else if (pdrLoggerRec2.getEventDate().after(monitorStatus.LastWarning)) {
                        monitorStatus.LastWarning = pdrLoggerRec2.getEventDate();
                    }
                    if (!pdrLoggerRec2.isAcknowledged()) {
                        if (monitorStatus.LastWarningNew == null) {
                            monitorStatus.LastWarningNew = pdrLoggerRec2.getEventDate();
                        } else if (pdrLoggerRec2.getEventDate().after(monitorStatus.LastWarningNew)) {
                            monitorStatus.LastWarningNew = pdrLoggerRec2.getEventDate();
                        }
                        ++monitorStatus.WarningCountNew;
                    }
                    ++monitorStatus.WarningCount;
                    continue;
                }
                if (!pdrLoggerRec2.getLevel().equalsIgnoreCase("ERROR")) continue;
                if (monitorStatus.LastError == null) {
                    monitorStatus.LastError = pdrLoggerRec2.getEventDate();
                } else if (pdrLoggerRec2.getEventDate().after(monitorStatus.LastError)) {
                    monitorStatus.LastError = pdrLoggerRec2.getEventDate();
                }
                if (!pdrLoggerRec2.isAcknowledged()) {
                    if (monitorStatus.LastErrorNew == null) {
                        monitorStatus.LastErrorNew = pdrLoggerRec2.getEventDate();
                    } else if (pdrLoggerRec2.getEventDate().after(monitorStatus.LastErrorNew)) {
                        monitorStatus.LastErrorNew = pdrLoggerRec2.getEventDate();
                    }
                    ++monitorStatus.ErrorCountNew;
                }
                ++monitorStatus.ErrorCount;
            }
        }
        return JsonUtilities.toJson(monitorStatus);
    }

    @WebPOST(Action=AuthorisationActionEnum.WRITE, Path="acknowledge")
    @WebContent(value=WebContent.MediaType.APPLICATION_JSON)
    public String acknowledgeLogMessages(@WebParam(source="_body", mandatory=true, validator=WebParamValidatorTypeJSON.class) logMessageAckSet logMessageAckSet2) throws Exception {
        Object object = null;
        if (logMessageAckSet2.list == null) {
            object = "Detected invalid POST data";
        } else if (logMessageAckSet2.list.isEmpty()) {
            object = "Detected empty list of log messages for acknowledgement";
        } else {
            pdrMonitorManager pdrMonitorManager2 = pdrMonitorManager.getInstance();
            int n = pdrMonitorManager2.acknowledgeLogMessages(logMessageAckSet2.list);
            object = "Acknowleged " + n + " log file messages";
        }
        return object;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD", "SIC_INNER_SHOULD_BE_STATIC"})
    private class MonitorStatus {
        public int WarningCount;
        public int WarningCountNew;
        public int ErrorCount;
        public int ErrorCountNew;
        public int InfoCount;
        public Date LastWarning;
        public Date LastWarningNew;
        public Date LastError;
        public Date LastErrorNew;
        public Date LastInfo;
        public Date StatusDate;

        private MonitorStatus() {
        }
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD", "SIC_INNER_SHOULD_BE_STATIC"})
    private class logMessageAckSet {
        public List<pdrLoggerRecAck> list;

        private logMessageAckSet() {
        }
    }
}

