/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Monitor.API;

import au.com.aemo.Common.Authentication.AuthorisationActionEnum;
import au.com.aemo.Common.Certificate.CertificateDetail;
import au.com.aemo.Common.Certificate.CertificateManager;
import au.com.aemo.Common.Certificate.CertificateSummary;
import au.com.aemo.Common.Certificate.WebServerConnectivity;
import au.com.aemo.Common.JSON.JsonUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Web.WebContent;
import au.com.aemo.Common.Web.WebGET;
import au.com.aemo.Common.Web.WebPOST;
import au.com.aemo.Common.Web.WebParam;
import au.com.aemo.Common.Web.WebParamValidationEnum;
import au.com.aemo.Common.Web.WebParamValidatorTypeJSON;
import au.com.aemo.Common.Web.WebPath;
import au.com.nemmco.Pdr.Monitor.API.TrustSet;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorConfigManager;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorSource;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorSourceCheck;

@WebPath(value="/api/SourceCheck")
public class WebAPISourceCheck {
    @WebGET(AdminAccessOnly=true, Action=AuthorisationActionEnum.READ, Path="Protocol")
    @WebContent(value=WebContent.MediaType.APPLICATION_JSON)
    public String getProtocol(@WebParam(source="Hostname", mandatory=true, validatorParam=WebParamValidationEnum.STR_OBJECT_ID) String string, @WebParam(source="Port", mandatory=true, validatorParam=WebParamValidationEnum.POSITIVE) int n) throws Exception {
        String string2 = null;
        pdrMonitorConfigManager pdrMonitorConfigManager2 = pdrMonitorConfigManager.getInstance();
        pdrMonitorSource pdrMonitorSource2 = pdrMonitorConfigManager2.getSource(string, n);
        if (pdrMonitorSource2 == null) {
            pdrMonitorSource2 = new pdrMonitorSource();
            pdrMonitorSource2.Hostname = string;
            pdrMonitorSource2.Port = n;
        }
        WebServerConnectivity webServerConnectivity = pdrMonitorConfigManager2.validateProtocol(pdrMonitorSource2);
        string2 = JsonUtilities.toJson(webServerConnectivity);
        return string2;
    }

    @WebPOST(AdminAccessOnly=true, Action=AuthorisationActionEnum.WRITE, Path="Certificate")
    @WebContent(value=WebContent.MediaType.APPLICATION_JSON)
    public String trustCertificate(@WebParam(source="_body", mandatory=true, validator=WebParamValidatorTypeJSON.class) TrustSet trustSet) throws Exception {
        Object object = null;
        try {
            pdrMonitorConfigManager pdrMonitorConfigManager2 = pdrMonitorConfigManager.getInstance();
            pdrMonitorSource pdrMonitorSource2 = pdrMonitorConfigManager2.getSource(trustSet.Hostname, trustSet.Port);
            if (pdrMonitorSource2 == null) {
                pdrMonitorSource2 = new pdrMonitorSource();
                pdrMonitorSource2.Hostname = trustSet.Hostname;
                pdrMonitorSource2.Port = trustSet.Port;
            }
            WebServerConnectivity webServerConnectivity = pdrMonitorConfigManager2.validateProtocol(pdrMonitorSource2);
            object = "Found no new certificates to trust";
            int n = 0;
            if (trustSet.Certificates != null) {
                for (CertificateSummary certificateSummary : trustSet.Certificates) {
                    for (CertificateDetail certificateDetail : webServerConnectivity.Certificates) {
                        if (!certificateDetail.SerialNumber.equalsIgnoreCase(certificateSummary.SerialNumber)) continue;
                        CertificateManager certificateManager = CertificateManager.getInstance();
                        if (certificateDetail.Cert != null) {
                            certificateManager.addTrustedCertificate(certificateSummary.CommonName, certificateDetail.Cert);
                        } else if (!Util.isBlank(certificateDetail.PublicKey)) {
                            certificateManager.addTrustedCertificate(certificateSummary.CommonName, certificateDetail.PublicKey);
                        } else {
                            throw new Exception("Missing x509 certificate or PEM string");
                        }
                        ++n;
                    }
                }
            }
            object = "Successfully trusted " + n + " new certificates";
        }
        catch (Exception exception) {
            object = "Failed to add certificate trusts: " + exception.getMessage();
        }
        return object;
    }

    @WebGET(AdminAccessOnly=true, Action=AuthorisationActionEnum.READ, Path="Version")
    @WebContent(value=WebContent.MediaType.APPLICATION_JSON)
    public String getSourceCheckVersion(@WebParam(source="Hostname", mandatory=true, validatorParam=WebParamValidationEnum.STR_OBJECT_ID) String string, @WebParam(source="API_Key", mandatory=true, validatorParam=WebParamValidationEnum.STR_HEX_KEY) String string2, @WebParam(source="Port", mandatory=true, validatorParam=WebParamValidationEnum.POSITIVE) int n, @WebParam(source="Encrypted", mandatory=true, validatorParam=WebParamValidationEnum.BOOLEAN) boolean bl) throws Exception {
        String string3 = null;
        pdrMonitorConfigManager pdrMonitorConfigManager2 = pdrMonitorConfigManager.getInstance();
        pdrMonitorSource pdrMonitorSource2 = new pdrMonitorSource();
        pdrMonitorSource2.Hostname = string;
        pdrMonitorSource2.Port = n;
        pdrMonitorSource2.API_Key = string2;
        pdrMonitorSource2.IsHttps = Util.booleanToInt(bl);
        pdrMonitorSourceCheck pdrMonitorSourceCheck2 = pdrMonitorConfigManager2.validateSource(pdrMonitorSource2);
        string3 = JsonUtilities.toJson(pdrMonitorSourceCheck2);
        return string3;
    }
}

