/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Monitor.API;

import au.com.aemo.Common.Database.DbHandler;
import au.com.aemo.Common.Database.DbManager;
import au.com.aemo.Common.Database.DbQueryResultsReader;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.nemmco.Pdr.Monitor.API.PerformanceHelperDataInterchange;
import au.com.nemmco.Pdr.Monitor.API.dataInterchangePerformanceRec;
import au.com.nemmco.Pdr.Monitor.API.getDIPerfBase;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorDataInterchangePerfSLA;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorSource;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class getDIPerfDataAggregate
extends getDIPerfBase
implements DbQueryResultsReader {
    private static Logger logger = LoggerFactory.getLogger(getDIPerfDataAggregate.class);
    private pdrMonitorDataInterchangePerfSLA conf;

    getDIPerfDataAggregate() {
    }

    private Date readDate(ResultSet resultSet, String string) throws SQLException {
        Timestamp timestamp = resultSet.getTimestamp(string);
        if (resultSet.wasNull()) {
            return null;
        }
        return new Date(timestamp.getTime());
    }

    public dataInterchangePerformanceRec loadFromRset(ResultSet resultSet) throws SQLException {
        dataInterchangePerformanceRec dataInterchangePerformanceRec2 = new dataInterchangePerformanceRec();
        dataInterchangePerformanceRec2.setIntervalEndDate(this.readDate(resultSet, "INTERVAL_END_DATE"));
        dataInterchangePerformanceRec2.setFileId(resultSet.getString("FILE_ID"));
        dataInterchangePerformanceRec2.setNoRecords(resultSet.getInt("NO_RECORDS"));
        if (dataInterchangePerformanceRec2.getNoRecords() == 1) {
            dataInterchangePerformanceRec2.setFilename(resultSet.getString("FILE_NAME"));
            dataInterchangePerformanceRec2.setFileExtension(resultSet.getString("FILE_EXTENSION"));
        }
        dataInterchangePerformanceRec2.setAemoCreateSeconds(resultSet.getDouble("AEMO_CREATE_SECONDS"));
        dataInterchangePerformanceRec2.setAemoDistributeSeconds(resultSet.getDouble("AEMO_DISTRIBUTE_SECONDS"));
        dataInterchangePerformanceRec2.setBatcherStartSeconds(resultSet.getDouble("BATCHER_START_SECONDS"));
        dataInterchangePerformanceRec2.setBatcherEndSeconds(resultSet.getDouble("BATCHER_END_SECONDS"));
        dataInterchangePerformanceRec2.setLoaderStartSeconds(resultSet.getDouble("LOADER_START_SECONDS"));
        dataInterchangePerformanceRec2.setLoaderEndSeconds(resultSet.getDouble("LOADER_END_SECONDS"));
        dataInterchangePerformanceRec2.setEnd2EndSeconds(dataInterchangePerformanceRec2.getAemoCreateSeconds() + dataInterchangePerformanceRec2.getAemoDistributeSeconds() + dataInterchangePerformanceRec2.getBatcherStartSeconds() + dataInterchangePerformanceRec2.getBatcherEndSeconds() + dataInterchangePerformanceRec2.getLoaderStartSeconds() + dataInterchangePerformanceRec2.getLoaderEndSeconds());
        if (this.conf != null) {
            dataInterchangePerformanceRec2.setEnd2EndSLA(Double.valueOf(this.conf.EndToEndSLA));
        }
        return dataInterchangePerformanceRec2;
    }

    private String getLoaderPredicateAdditional(Date date, Date date2, boolean bl, String string, DbHandler dbHandler) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!bl) {
            stringBuilder.append(" and ");
            stringBuilder.append(string);
            stringBuilder.append(".START_DATE between ");
            stringBuilder.append(dbHandler.getSqlDate(Util.dateOffset(date, -1, 5)));
            stringBuilder.append(" and ");
            stringBuilder.append(dbHandler.getSqlDate(date2));
        }
        return stringBuilder.toString();
    }

    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="All parameters are either itnernal configuration or cleansed by a validation layer. Called by trusted code and no material SQL injection risk")
    public List<dataInterchangePerformanceRec> loadData(Connection connection, List<pdrMonitorSource> list, List<pdrMonitorSource> list2, Date date, Date date2, int n, List<String> list3, String string) throws Exception {
        String string2;
        DbHandler dbHandler = DbManager.getDbHandler();
        boolean bl = false;
        if (list3.size() == 1) {
            string2 = list3.get(0);
            list3.add(string2 + "_LEGACY");
            this.conf = PerformanceHelperDataInterchange.getPerformanceConf(string2);
            bl = this.conf != null;
        }
        string2 = dbHandler.getSqlDateRoundUp("l.INTERVAL_END_DATE", n);
        if (this.conf == null) {
            string2 = dbHandler.getSqlDateRoundUp("l.END_DATE", n);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" select ");
        stringBuilder.append(string2);
        stringBuilder.append(" as INTERVAL_END_DATE ");
        stringBuilder.append(" ,MAX(l.FILE_ID) as FILE_ID");
        stringBuilder.append(" ,COUNT(1) as NO_RECORDS");
        stringBuilder.append(" ,MAX(l.FILE_NAME) as FILE_NAME");
        stringBuilder.append(" ,MAX(l.FILE_EXTENSION) as FILE_EXTENSION");
        String string3 = "l.CONTENT_CREATION_DATE";
        if (this.conf != null) {
            string3 = dbHandler.getSqlDateAdd("l.INTERVAL_END_DATE", Integer.toString(-this.conf.BusinessCycleMins), 12);
        }
        stringBuilder.append(",AVG(");
        stringBuilder.append(dbHandler.getSqlDateDiffInSecs(string3, "l.CONTENT_CREATION_DATE"));
        stringBuilder.append(") as AEMO_CREATE_SECONDS");
        stringBuilder.append(",AVG(");
        stringBuilder.append(dbHandler.getSqlDateDiffInSecs("l.CONTENT_CREATION_DATE", "b.CONTENT_CREATION_DATE"));
        stringBuilder.append(") as AEMO_DISTRIBUTE_SECONDS");
        stringBuilder.append(",AVG(");
        stringBuilder.append(dbHandler.getSqlDateDiffInSecs("b.CONTENT_CREATION_DATE", "b.START_DATE"));
        stringBuilder.append(") as BATCHER_START_SECONDS");
        stringBuilder.append(",AVG(");
        stringBuilder.append(dbHandler.getSqlDateDiffInSecs("b.START_DATE", "b.END_DATE"));
        stringBuilder.append(") as BATCHER_END_SECONDS");
        stringBuilder.append(",AVG(");
        stringBuilder.append(dbHandler.getSqlDateDiffInSecs("b.END_DATE", "l.START_DATE"));
        stringBuilder.append(") as LOADER_START_SECONDS");
        stringBuilder.append(",AVG(");
        stringBuilder.append(dbHandler.getSqlDateDiffInSecs("l.START_DATE", "l.END_DATE"));
        stringBuilder.append(") as LOADER_END_SECONDS");
        stringBuilder.append(" from");
        stringBuilder.append(" PDR_MONITOR_PERFORMANCE l");
        stringBuilder.append(" ,PDR_MONITOR_PERFORMANCE b");
        stringBuilder.append(" where");
        stringBuilder.append(" l.PDR_MONITOR_ID in (");
        String string4 = "";
        for (pdrMonitorSource pdrMonitorSource2 : list2) {
            stringBuilder.append(string4);
            stringBuilder.append(pdrMonitorSource2.pdr_monitor_id);
            string4 = ",";
        }
        stringBuilder.append(")");
        stringBuilder.append(this.getLoaderPredicate(date, date2, bl, "l", dbHandler));
        stringBuilder.append(this.getLoaderPredicateAdditional(date, date2, bl, "l", dbHandler));
        stringBuilder.append(PerformanceHelperDataInterchange.buildSQLPredicate("l.FILE_ID", list3));
        if (!Util.isBlank(string)) {
            stringBuilder.append(" and l.CONFIDENTIALITY = '");
            stringBuilder.append(string.toUpperCase());
            stringBuilder.append("'");
        }
        stringBuilder.append(" and b.PDR_MONITOR_ID in (");
        string4 = "";
        for (pdrMonitorSource pdrMonitorSource2 : list) {
            stringBuilder.append(string4);
            stringBuilder.append(pdrMonitorSource2.pdr_monitor_id);
            string4 = ",";
        }
        stringBuilder.append(")");
        stringBuilder.append(" and b.FILE_NAME = l.FILE_NAME");
        stringBuilder.append(" and l.START_DATE = (select MIN(START_DATE) from PDR_MONITOR_PERFORMANCE where PDR_MONITOR_PERFORMANCE.PDR_MONITOR_ID=l.PDR_MONITOR_ID" + this.getLoaderPredicate(date, date2, bl, "PDR_MONITOR_PERFORMANCE", dbHandler) + this.getLoaderPredicateAdditional(date, date2, bl, "PDR_MONITOR_PERFORMANCE", dbHandler) + " and PDR_MONITOR_PERFORMANCE.FILE_NAME=l.FILE_NAME)");
        stringBuilder.append(" and b.START_DATE = (select MIN(START_DATE) from PDR_MONITOR_PERFORMANCE where PDR_MONITOR_PERFORMANCE.PDR_MONITOR_ID=b.PDR_MONITOR_ID and PDR_MONITOR_PERFORMANCE.FILE_NAME=b.FILE_NAME)");
        stringBuilder.append(" group by ");
        stringBuilder.append(string2);
        stringBuilder.append(" order by ");
        stringBuilder.append(string2);
        Util_Logger.debug(logger, stringBuilder.toString());
        return DbManager.selectObjects(connection, stringBuilder.toString(), this::loadFromRset);
    }
}

