/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Monitor.API;

import au.com.aemo.Common.Database.DbHandler;
import au.com.aemo.Common.Database.DbManager;
import au.com.aemo.Common.Database.DbQueryResultsReader;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.nemmco.Pdr.Monitor.API.PerformanceHelperDataInterchange;
import au.com.nemmco.Pdr.Monitor.API.dataInterchangePerformanceRec;
import au.com.nemmco.Pdr.Monitor.API.getDIPerfBase;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorDataInterchangePerfSLA;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorSource;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class getDIPerfDataRaw
extends getDIPerfBase
implements DbQueryResultsReader {
    private static Logger logger = LoggerFactory.getLogger(getDIPerfDataRaw.class);

    getDIPerfDataRaw() {
    }

    private Date readDate(ResultSet resultSet, String string) throws SQLException {
        Timestamp timestamp = resultSet.getTimestamp(string);
        if (resultSet.wasNull()) {
            return null;
        }
        return new Date(timestamp.getTime());
    }

    private Double dateDiff(Date date, Date date2) {
        if (date == null) {
            return null;
        }
        if (date2 == null) {
            return null;
        }
        return (double)(date2.getTime() - date.getTime()) / 1000.0;
    }

    public dataInterchangePerformanceRec loadFromRset(ResultSet resultSet) throws SQLException {
        dataInterchangePerformanceRec dataInterchangePerformanceRec2 = new dataInterchangePerformanceRec();
        dataInterchangePerformanceRec2.setDataSource(resultSet.getString("DATA_SOURCE"));
        dataInterchangePerformanceRec2.setFileId(resultSet.getString("FILE_ID"));
        dataInterchangePerformanceRec2.setNoRecords(1);
        dataInterchangePerformanceRec2.setFilename(resultSet.getString("FILE_NAME"));
        dataInterchangePerformanceRec2.setFileExtension(resultSet.getString("FILE_EXTENSION"));
        dataInterchangePerformanceRec2.setIntervalEndDate(this.readDate(resultSet, "INTERVAL_END_DATE"));
        dataInterchangePerformanceRec2.setFileSize(resultSet.getInt("FILE_SIZE"));
        dataInterchangePerformanceRec2.setDatabaseRows(resultSet.getInt("DATABASE_ROWS"));
        pdrMonitorDataInterchangePerfSLA pdrMonitorDataInterchangePerfSLA2 = PerformanceHelperDataInterchange.getPerformanceConf(dataInterchangePerformanceRec2.getFileId());
        Date date = this.readDate(resultSet, "AEMO_CREATE_DATE");
        if (pdrMonitorDataInterchangePerfSLA2 != null && dataInterchangePerformanceRec2.getIntervalEndDate() != null) {
            date = Util.dateOffset(dataInterchangePerformanceRec2.getIntervalEndDate(), -pdrMonitorDataInterchangePerfSLA2.BusinessCycleMins, 12);
        }
        Date date2 = this.readDate(resultSet, "AEMO_CREATE_DATE");
        Date date3 = this.readDate(resultSet, "AEMO_DISTRIBUTE_DATE");
        Date date4 = this.readDate(resultSet, "BATCHER_START_DATE");
        Date date5 = this.readDate(resultSet, "BATCHER_END_DATE");
        Date date6 = this.readDate(resultSet, "LOADER_START_DATE");
        Date date7 = this.readDate(resultSet, "LOADER_END_DATE");
        dataInterchangePerformanceRec2.setIntervalStartDate(date);
        dataInterchangePerformanceRec2.setAemoCreateSeconds(this.dateDiff(date, date2));
        dataInterchangePerformanceRec2.setAemoDistributeSeconds(this.dateDiff(date2, date3));
        dataInterchangePerformanceRec2.setBatcherStartSeconds(this.dateDiff(date3, date4));
        dataInterchangePerformanceRec2.setBatcherEndSeconds(this.dateDiff(date4, date5));
        dataInterchangePerformanceRec2.setLoaderStartSeconds(this.dateDiff(date5, date6));
        dataInterchangePerformanceRec2.setLoaderEndSeconds(this.dateDiff(date6, date7));
        dataInterchangePerformanceRec2.setEnd2EndSeconds(this.dateDiff(date, date7));
        if (pdrMonitorDataInterchangePerfSLA2 != null) {
            dataInterchangePerformanceRec2.setEnd2EndSLA(Double.valueOf(pdrMonitorDataInterchangePerfSLA2.EndToEndSLA));
        }
        return dataInterchangePerformanceRec2;
    }

    /*
     * WARNING - void declaration
     */
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="All parameters are either itnernal configuration or cleansed by a validation layer. Called by trusted code and no material SQL injection risk")
    public List<dataInterchangePerformanceRec> loadData(Connection connection, List<pdrMonitorSource> list, List<pdrMonitorSource> list2, Date date, Date date2, List<String> list3, String string, String string2) throws Exception {
        void var15_20;
        Object object2;
        CharSequence charSequence;
        DbHandler dbHandler = DbManager.getDbHandler();
        boolean bl = false;
        boolean bl2 = false;
        if (list3.size() == 1) {
            charSequence = list3.get(0);
            list3.add((String)charSequence + "_LEGACY");
            bl = !((String)charSequence).contains("*");
            object2 = PerformanceHelperDataInterchange.getPerformanceConf((String)charSequence);
            bl2 = object2 != null;
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append(" select");
        ((StringBuilder)charSequence).append(" l.DATA_SOURCE");
        ((StringBuilder)charSequence).append(" ,l.FILE_ID");
        ((StringBuilder)charSequence).append(" ,l.FILE_NAME");
        ((StringBuilder)charSequence).append(" ,l.FILE_EXTENSION");
        ((StringBuilder)charSequence).append(" ,l.INTERVAL_END_DATE");
        ((StringBuilder)charSequence).append(" ,l.CONTENT_CREATION_DATE as AEMO_CREATE_DATE");
        ((StringBuilder)charSequence).append(" ,b.CONTENT_CREATION_DATE as AEMO_DISTRIBUTE_DATE");
        ((StringBuilder)charSequence).append(" ,b.START_DATE as BATCHER_START_DATE");
        ((StringBuilder)charSequence).append(" ,b.END_DATE as BATCHER_END_DATE");
        ((StringBuilder)charSequence).append(" ,l.START_DATE as LOADER_START_DATE");
        ((StringBuilder)charSequence).append(" ,l.END_DATE as LOADER_END_DATE");
        ((StringBuilder)charSequence).append(" ,b.JOB_SIZE as FILE_SIZE");
        ((StringBuilder)charSequence).append(" ,l.JOB_SIZE as DATABASE_ROWS");
        ((StringBuilder)charSequence).append(" from");
        ((StringBuilder)charSequence).append(" PDR_MONITOR_PERFORMANCE l");
        ((StringBuilder)charSequence).append(" ,PDR_MONITOR_PERFORMANCE b");
        ((StringBuilder)charSequence).append(" where");
        ((StringBuilder)charSequence).append(" l.PDR_MONITOR_ID in (");
        object2 = "";
        for (pdrMonitorSource object3 : list2) {
            ((StringBuilder)charSequence).append((String)object2);
            ((StringBuilder)charSequence).append(object3.pdr_monitor_id);
            object2 = ",";
        }
        ((StringBuilder)charSequence).append(")");
        ((StringBuilder)charSequence).append(this.getLoaderPredicate(date, date2, bl2, "l", dbHandler));
        ((StringBuilder)charSequence).append(PerformanceHelperDataInterchange.buildSQLPredicate("l.FILE_ID", list3));
        ((StringBuilder)charSequence).append(PerformanceHelperDataInterchange.buildSQLPredicate("l.FILE_NAME", string));
        if (!Util.isBlank(string2)) {
            ((StringBuilder)charSequence).append(" and l.CONFIDENTIALITY = '");
            ((StringBuilder)charSequence).append(string2.toUpperCase());
            ((StringBuilder)charSequence).append("'");
        }
        ((StringBuilder)charSequence).append(" and b.PDR_MONITOR_ID in (");
        object2 = "";
        for (pdrMonitorSource pdrMonitorSource2 : list) {
            ((StringBuilder)charSequence).append((String)object2);
            ((StringBuilder)charSequence).append(pdrMonitorSource2.pdr_monitor_id);
            object2 = ",";
        }
        ((StringBuilder)charSequence).append(")");
        ((StringBuilder)charSequence).append(" and b.FILE_NAME = l.FILE_NAME");
        ((StringBuilder)charSequence).append(" and l.START_DATE = (select MIN(START_DATE) from PDR_MONITOR_PERFORMANCE where PDR_MONITOR_PERFORMANCE.PDR_MONITOR_ID=l.PDR_MONITOR_ID" + this.getLoaderPredicate(date, date2, bl2, "PDR_MONITOR_PERFORMANCE", dbHandler) + " and PDR_MONITOR_PERFORMANCE.FILE_NAME=l.FILE_NAME)");
        ((StringBuilder)charSequence).append(" and b.START_DATE = (select MIN(START_DATE) from PDR_MONITOR_PERFORMANCE where PDR_MONITOR_PERFORMANCE.PDR_MONITOR_ID=b.PDR_MONITOR_ID and PDR_MONITOR_PERFORMANCE.FILE_NAME=b.FILE_NAME)");
        ((StringBuilder)charSequence).append(" order by");
        ((StringBuilder)charSequence).append(" l.INTERVAL_END_DATE, l.END_DATE");
        Util_Logger.debug(logger, ((StringBuilder)charSequence).toString());
        List<dataInterchangePerformanceRec> list4 = DbManager.selectObjects(connection, ((StringBuilder)charSequence).toString(), this::loadFromRset);
        ArrayList<dataInterchangePerformanceRec> arrayList = new ArrayList<dataInterchangePerformanceRec>();
        if (bl) {
            dataInterchangePerformanceRec dataInterchangePerformanceRec2 = null;
            Iterator iterator = list4.iterator();
            while (iterator.hasNext()) {
                dataInterchangePerformanceRec dataInterchangePerformanceRec3 = (dataInterchangePerformanceRec)iterator.next();
                if (dataInterchangePerformanceRec2 == null) {
                    arrayList.add(dataInterchangePerformanceRec3);
                } else if (dataInterchangePerformanceRec2.getIntervalEndDate() != null && dataInterchangePerformanceRec3.getIntervalEndDate() != null) {
                    if (dataInterchangePerformanceRec2.getIntervalEndDate().before(dataInterchangePerformanceRec3.getIntervalEndDate())) {
                        arrayList.add(dataInterchangePerformanceRec3);
                    }
                } else if (dataInterchangePerformanceRec2.getFilename() != null && dataInterchangePerformanceRec3.getFilename() != null) {
                    String string3 = null;
                    String string4 = null;
                    if (dataInterchangePerformanceRec2.getFilename().length() > dataInterchangePerformanceRec3.getFilename().length()) {
                        string3 = dataInterchangePerformanceRec2.getFilename();
                        string4 = dataInterchangePerformanceRec3.getFilename() + "_LEGACY";
                    } else {
                        string3 = dataInterchangePerformanceRec3.getFilename();
                        string4 = dataInterchangePerformanceRec2.getFilename() + "_LEGACY";
                    }
                    if (!string3.equalsIgnoreCase(string4)) {
                        arrayList.add(dataInterchangePerformanceRec3);
                    }
                } else {
                    arrayList.add(dataInterchangePerformanceRec3);
                }
                dataInterchangePerformanceRec2 = dataInterchangePerformanceRec3;
            }
        } else {
            Object object = list4;
        }
        return var15_20;
    }
}

