/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Monitor.API;

import au.com.aemo.Common.Database.DbHandler;
import au.com.aemo.Common.Database.DbManager;
import au.com.aemo.Common.Database.DbQueryResultsReader;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.nemmco.Pdr.Monitor.API.PerformanceHelperDataInterchange;
import au.com.nemmco.Pdr.Monitor.API.dataInterchangePerformanceSummaryRec;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorConfigManager;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorDataInterchangePerfSLA;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorSource;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class getDIPerfDataStats
implements DbQueryResultsReader {
    private static Logger logger = LoggerFactory.getLogger(getDIPerfDataStats.class);

    getDIPerfDataStats() {
    }

    private Date readDate(ResultSet resultSet, String string) throws SQLException {
        Timestamp timestamp = resultSet.getTimestamp(string);
        if (resultSet.wasNull()) {
            return null;
        }
        return new Date(timestamp.getTime());
    }

    public dataInterchangePerformanceSummaryRec loadFromRset(ResultSet resultSet) throws SQLException {
        dataInterchangePerformanceSummaryRec dataInterchangePerformanceSummaryRec2 = new dataInterchangePerformanceSummaryRec();
        dataInterchangePerformanceSummaryRec2.PeriodEnding = this.readDate(resultSet, "PERIOD_ENDING");
        dataInterchangePerformanceSummaryRec2.ReplicationMin = resultSet.getDouble("REPLICATION_MIN");
        dataInterchangePerformanceSummaryRec2.ReplicationAvg = resultSet.getDouble("REPLICATION_AVG");
        dataInterchangePerformanceSummaryRec2.ReplicationMax = resultSet.getDouble("REPLICATION_MAX");
        return dataInterchangePerformanceSummaryRec2;
    }

    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="All parameters are either itnernal configuration or cleansed by a validation layer. Called by trusted code and no material SQL injection risk")
    public List<dataInterchangePerformanceSummaryRec> loadData(Connection connection, List<pdrMonitorSource> list, List<String> list2, Date date, Date date2, int n) throws Exception {
        String string;
        DbHandler dbHandler = DbManager.getDbHandler();
        pdrMonitorConfigManager pdrMonitorConfigManager2 = pdrMonitorConfigManager.getInstance();
        pdrMonitorDataInterchangePerfSLA pdrMonitorDataInterchangePerfSLA2 = null;
        if (list2.size() == 1) {
            string = list2.get(0);
            pdrMonitorDataInterchangePerfSLA2 = pdrMonitorConfigManager2.getPerfConfig(string);
            list2.add(string + "_LEGACY");
        }
        string = dbHandler.getSqlDateRoundUp("l.INTERVAL_END_DATE", n);
        if (pdrMonitorDataInterchangePerfSLA2 == null) {
            string = dbHandler.getSqlDateRoundUp("l.END_DATE", n);
        }
        String string2 = "l.CONTENT_CREATION_DATE";
        if (pdrMonitorDataInterchangePerfSLA2 != null) {
            string2 = dbHandler.getSqlDateAdd("l.INTERVAL_END_DATE", Integer.toString(-pdrMonitorDataInterchangePerfSLA2.BusinessCycleMins), 12);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" select ");
        stringBuilder.append(string);
        stringBuilder.append(" as PERIOD_ENDING");
        stringBuilder.append(",MIN(");
        stringBuilder.append(dbHandler.getSqlDateDiffInSecs(string2, "l.END_DATE"));
        stringBuilder.append(") as REPLICATION_MIN");
        stringBuilder.append(" ,AVG(");
        stringBuilder.append(dbHandler.getSqlDateDiffInSecs(string2, "l.END_DATE"));
        stringBuilder.append(") as REPLICATION_AVG");
        stringBuilder.append(" ,MAX(");
        stringBuilder.append(dbHandler.getSqlDateDiffInSecs(string2, "l.END_DATE"));
        stringBuilder.append(") as REPLICATION_MAX");
        stringBuilder.append(" from");
        stringBuilder.append(" PDR_MONITOR_PERFORMANCE l");
        stringBuilder.append(" where");
        stringBuilder.append(" l.PDR_MONITOR_ID in (");
        String string3 = "";
        for (pdrMonitorSource pdrMonitorSource2 : list) {
            stringBuilder.append(string3);
            stringBuilder.append(pdrMonitorSource2.pdr_monitor_id);
            string3 = ",";
        }
        stringBuilder.append(")");
        if (pdrMonitorDataInterchangePerfSLA2 != null) {
            stringBuilder.append(" and l.INTERVAL_END_DATE > ");
            stringBuilder.append(dbHandler.getSqlDate(date));
            stringBuilder.append(" and l.INTERVAL_END_DATE <= ");
            stringBuilder.append(dbHandler.getSqlDate(date2));
        } else {
            stringBuilder.append(" and l.END_DATE BETWEEN ");
            stringBuilder.append(dbHandler.getSqlDate(date));
            stringBuilder.append(" and ");
            stringBuilder.append(dbHandler.getSqlDate(date2));
        }
        stringBuilder.append(PerformanceHelperDataInterchange.buildSQLPredicate("l.FILE_ID", list2));
        stringBuilder.append(" and l.CONFIDENTIALITY = 'PUBLIC'");
        stringBuilder.append(" and l.PROCESS_ELEMENT_PARENT_ID is NULL");
        stringBuilder.append(" and l.START_DATE = (select MIN(START_DATE) from PDR_MONITOR_PERFORMANCE where PDR_MONITOR_PERFORMANCE.PDR_MONITOR_ID=l.PDR_MONITOR_ID and PDR_MONITOR_PERFORMANCE.PROCESS_ELEMENT_PARENT_ID is NULL and PDR_MONITOR_PERFORMANCE.FILE_NAME=l.FILE_NAME)");
        stringBuilder.append(" GROUP BY ");
        stringBuilder.append(string);
        stringBuilder.append(" ORDER BY ");
        stringBuilder.append(string);
        Util_Logger.debug(logger, stringBuilder.toString());
        return DbManager.selectObjects(connection, stringBuilder.toString(), this::loadFromRset);
    }
}

