/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Monitor;

import au.com.aemo.Common.Application.ApplicationManager;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.nemmco.Pdr.Monitor.Config.ConfigWrapper;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorConfigManager;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorSource;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorSourceCheck;
import au.com.nemmco.Pdr.Monitor.pdrMonitor;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppPdrMonitorRegisterSource {
    private static Logger logger = LoggerFactory.getLogger(AppPdrMonitorRegisterSource.class);

    @SuppressFBWarnings(value={"NP_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"}, justification="Fields populated by JSON serialisations")
    public static void main(String[] stringArray) throws Exception {
        Object object;
        Options options = new Options();
        options.addRequiredOption("h", "host", true, "The host where the application is deployed");
        options.addRequiredOption("p", "port", true, "The port number on which the application API services are exposed");
        options.addOption("k", "key", true, "The API access key");
        options.addOption("s", "system", true, "The system the application is associated with");
        options.addOption("a", "active", true, "Whether the application is set active (true) or inactive (false)");
        options.addOption("e", "encrypted", true, "Whether the application uses encrypted communication");
        options.addOption("aa", "autoactive", true, "Whether the application active status is managed automatically (true) or manually (false)");
        DefaultParser defaultParser = new DefaultParser();
        CommandLine commandLine = null;
        try {
            commandLine = defaultParser.parse(options, stringArray);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            object = new HelpFormatter();
            object.printHelp(AppPdrMonitorRegisterSource.class.getSimpleName(), options);
            System.exit(1);
        }
        ApplicationManager applicationManager = ApplicationManager.getInstance();
        object = (ConfigWrapper)applicationManager.init(AppPdrMonitorRegisterSource.class.getSimpleName(), "1.3.1", AppPdrMonitorRegisterSource.class, pdrMonitor.CONFIGURATION_FILE, ConfigWrapper.class, null, applicationManager.buildStartOptions().startDatabase().createClientCertificateStore());
        try {
            String string = commandLine.getOptionValue("host");
            int n = Integer.parseInt(commandLine.getOptionValue("port"));
            String string2 = commandLine.getOptionValue("key", null);
            String string3 = commandLine.getOptionValue("system", null);
            String string4 = commandLine.getOptionValue("active", null);
            String string5 = commandLine.getOptionValue("autoactive", null);
            Boolean bl = null;
            if (!Util.isBlank(string4)) {
                bl = string4.equalsIgnoreCase("true") || string4.equalsIgnoreCase("yes") || string4.equalsIgnoreCase("y");
            }
            String string6 = commandLine.getOptionValue("encrypted", null);
            Boolean bl2 = null;
            if (!Util.isBlank(string6)) {
                bl2 = string6.equalsIgnoreCase("true") || string6.equalsIgnoreCase("yes") || string6.equalsIgnoreCase("y");
            }
            Boolean bl3 = null;
            if (!Util.isBlank(string5)) {
                bl3 = string5.equalsIgnoreCase("true") || string5.equalsIgnoreCase("yes") || string5.equalsIgnoreCase("y");
            }
            pdrMonitorConfigManager pdrMonitorConfigManager2 = pdrMonitorConfigManager.getInstance();
            pdrMonitorConfigManager2.setConfig((ConfigWrapper)object, false);
            pdrMonitorConfigManager2.loadFromDatabase();
            boolean bl4 = false;
            pdrMonitorSource pdrMonitorSource2 = null;
            for (pdrMonitorSource pdrMonitorSource3 : pdrMonitorConfigManager2.getSources()) {
                if (!pdrMonitorSource3.Hostname.equalsIgnoreCase(string) || pdrMonitorSource3.Port != n) continue;
                pdrMonitorSource2 = pdrMonitorSource3;
            }
            if (pdrMonitorSource2 == null) {
                pdrMonitorSource2 = new pdrMonitorSource();
                pdrMonitorSource2.Hostname = string;
                pdrMonitorSource2.Port = n;
                if (Util.isBlank(string2)) {
                    throw new Exception("API key parameter is required for registering a new application");
                }
                pdrMonitorSource2.API_Key = string2;
                if (Util.isBlank(string3)) {
                    throw new Exception("System parameter is required for registering a new application");
                }
                pdrMonitorSource2.System_Id = string3;
                bl4 = true;
                Util_Logger.info(logger, "Registering new application on host " + pdrMonitorSource2.Hostname + " on port " + pdrMonitorSource2.Port);
            }
            if (!Util.isBlank(string2)) {
                pdrMonitorSource2.API_Key = string2;
            }
            if (bl != null) {
                pdrMonitorSource2.IsActive = Util.booleanToInt(bl);
            }
            if (bl2 != null) {
                pdrMonitorSource2.IsHttps = Util.booleanToInt(bl2);
            }
            if (bl3 != null) {
                pdrMonitorSource2.IsAutoActive = Util.booleanToInt(bl3);
            }
            pdrMonitorSourceCheck pdrMonitorSourceCheck2 = pdrMonitorConfigManager2.validateSource(pdrMonitorSource2);
            pdrMonitorSource2.Instance_Id = pdrMonitorSourceCheck2.App.InstanceId;
            pdrMonitorSource2.App_Name = pdrMonitorSourceCheck2.App.Name;
            pdrMonitorSource2.App_Version = pdrMonitorSourceCheck2.App.Version;
            pdrMonitorConfigManager2.saveSource(pdrMonitorSource2);
            if (bl4) {
                Util_Logger.info(logger, "Registered new application " + pdrMonitorSource2.App_Name + " with PDR_MONITOR_ID " + pdrMonitorSource2.pdr_monitor_id + " at host " + pdrMonitorSource2.Hostname + " on port " + pdrMonitorSource2.Port);
            } else {
                Util_Logger.info(logger, "Updated existing application " + pdrMonitorSource2.App_Name + " registered with PDR_MONITOR_ID " + pdrMonitorSource2.pdr_monitor_id + " at host " + pdrMonitorSource2.Hostname + " on port " + pdrMonitorSource2.Port);
            }
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error registering application to monitor: " + exception.getMessage(), exception);
            System.exit(1);
        }
        System.exit(0);
    }
}

