/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Monitor.Config;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.Application.ApplicationManager;
import au.com.aemo.Common.Authentication.KeyManager;
import au.com.aemo.Common.Certificate.CertificateList;
import au.com.aemo.Common.Certificate.CertificateManager;
import au.com.aemo.Common.Certificate.WebServerConnectivity;
import au.com.aemo.Common.Database.DbManager;
import au.com.aemo.Common.JSON.JsonUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Web.WebClient;
import au.com.aemo.Common.Web.WebClientAuthHMAC;
import au.com.aemo.Common.Web.WebContent;
import au.com.aemo.Common.Web.WebHttpResponse;
import au.com.nemmco.Pdr.Monitor.Collectors.pdrMonitorCollectorManager;
import au.com.nemmco.Pdr.Monitor.Config.ConfigWrapper;
import au.com.nemmco.Pdr.Monitor.Config.PerfFileConfig;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorDataInterchangePerfFile;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorDataInterchangePerfSLA;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorLatestDataConfig;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorSource;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorSourceCheck;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorSystem;
import au.com.nemmco.Pdr.Monitor.Config.pdrMonitorSystemGrants;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrMonitorConfigManager {
    public static final int DATABASE_REFRESH_CYCLE_MINS = 2;
    public static final int DATABASE_SOURCE_FILE_EVENT_UPDATE_MINS = 60;
    private static Logger logger = LoggerFactory.getLogger(pdrMonitorConfigManager.class);
    private Map<Integer, pdrMonitorSource> itsSources = new HashMap<Integer, pdrMonitorSource>();
    private Map<String, pdrMonitorDataInterchangePerfSLA> itsPerfSLAConfig = new HashMap<String, pdrMonitorDataInterchangePerfSLA>();
    private volatile PerfFileConfig itsPerfFilesConfig = new PerfFileConfig();
    private Map<String, pdrMonitorLatestDataConfig> itsLatestDataConfig = new HashMap<String, pdrMonitorLatestDataConfig>();
    private Map<String, pdrMonitorSystem> itsSystems = new HashMap<String, pdrMonitorSystem>();
    private ConfigWrapper itsConfig;
    private volatile boolean itsCacheRefreshOnSave = true;

    private pdrMonitorConfigManager() {
    }

    public static pdrMonitorConfigManager getInstance() {
        return SingletonHolder.instance;
    }

    public ConfigWrapper getConfig() {
        return this.itsConfig;
    }

    public void setConfig(ConfigWrapper configWrapper) {
        this.itsConfig = configWrapper;
    }

    public void setConfig(ConfigWrapper configWrapper, boolean bl) {
        this.itsConfig = configWrapper;
        this.itsCacheRefreshOnSave = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NP_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"}, justification="Fields populated by database object serialisation")
    public synchronized void loadFromDatabase() throws ApplicationException {
        Connection connection = null;
        try {
            List<pdrMonitorDataInterchangePerfFile> list;
            Object object;
            connection = DbManager.getDbConnection();
            List<pdrMonitorSystem> list2 = DbManager.selectObjects(connection, pdrMonitorSystem.class, null, "PDR_MONITOR_SYSTEM", "Select * from PDR_MONITOR_SYSTEM");
            List<pdrMonitorSystemGrants> list3 = DbManager.selectObjects(connection, pdrMonitorSystemGrants.class, null, "PDR_MONITOR_SYSTEM_GRANTS", "Select * from PDR_MONITOR_SYSTEM_GRANTS");
            HashMap<String, pdrMonitorSystem> hashMap2 = new HashMap<String, pdrMonitorSystem>();
            for (pdrMonitorSystem object22 : list2) {
                for (pdrMonitorSystemGrants pdrMonitorSystemGrants2 : list3) {
                    if (!pdrMonitorSystemGrants2.System_Id.equalsIgnoreCase(object22.System_Id)) continue;
                    object22.Grants.add(pdrMonitorSystemGrants2);
                }
                hashMap2.put(object22.System_Id.toUpperCase(), object22);
            }
            this.itsSystems = hashMap2;
            Util_Logger.info(logger, "Loaded " + this.itsSystems.size() + " system configurations from database");
            List<pdrMonitorSource> list4 = DbManager.selectObjects(connection, pdrMonitorSource.class, null, "PDR_MONITOR_SOURCE", "Select * from PDR_MONITOR_SOURCE");
            HashMap<Integer, pdrMonitorSource> hashMap = new HashMap<Integer, pdrMonitorSource>();
            Object object2 = list4.iterator();
            while (object2.hasNext()) {
                pdrMonitorSource pdrMonitorSource2 = (pdrMonitorSource)((Object)object2.next());
                hashMap.put(pdrMonitorSource2.pdr_monitor_id, pdrMonitorSource2);
            }
            this.itsSources = hashMap;
            Util_Logger.info(logger, "Loaded " + this.itsSources.size() + " source configurations from database");
            object2 = DbManager.selectObjects(connection, pdrMonitorDataInterchangePerfSLA.class, null, "PDR_MONITOR_PERFORMANCE_CONFIG", "Select * from PDR_MONITOR_PERFORMANCE_CONFIG");
            HashMap<String, pdrMonitorDataInterchangePerfSLA> hashMap3 = new HashMap<String, pdrMonitorDataInterchangePerfSLA>();
            Object object3 = object2.iterator();
            while (object3.hasNext()) {
                object = (pdrMonitorDataInterchangePerfSLA)object3.next();
                hashMap3.put(((pdrMonitorDataInterchangePerfSLA)object).FileId.toUpperCase(), (pdrMonitorDataInterchangePerfSLA)object);
            }
            this.itsPerfSLAConfig = hashMap3;
            Util_Logger.info(logger, "Loaded " + this.itsPerfSLAConfig.size() + " performance configurations from database");
            object3 = DbManager.selectObjects(connection, pdrMonitorLatestDataConfig.class, null, "PDR_MONITOR_LATEST_DATA_CNF", "Select * from PDR_MONITOR_LATEST_DATA_CNF");
            object = new HashMap();
            Object object4 = object3.iterator();
            while (object4.hasNext()) {
                list = (pdrMonitorLatestDataConfig)object4.next();
                object.put(((pdrMonitorLatestDataConfig)((Object)list)).DataModelTable.toUpperCase(), list);
            }
            this.itsLatestDataConfig = object;
            Util_Logger.info(logger, "Loaded " + this.itsLatestDataConfig.size() + " latest data configurations from database");
            if (this.itsPerfFilesConfig.getLastPerfFileEvent() == null) {
                object4 = DbManager.selectObjects(connection, pdrMonitorDataInterchangePerfFile.class, null, "PDR_MONITOR_PERFORMANCE_FILES", "Select * from PDR_MONITOR_PERFORMANCE_FILES");
                list = new PerfFileConfig();
                Iterator iterator = object4.iterator();
                while (iterator.hasNext()) {
                    pdrMonitorDataInterchangePerfFile pdrMonitorDataInterchangePerfFile2 = (pdrMonitorDataInterchangePerfFile)iterator.next();
                    ((PerfFileConfig)((Object)list)).addPerfFileEvent(pdrMonitorDataInterchangePerfFile2.pdr_monitor_id, pdrMonitorDataInterchangePerfFile2.FileId, pdrMonitorDataInterchangePerfFile2.LastProcessed);
                }
                this.itsPerfFilesConfig = list;
                Util_Logger.info(logger, "Loaded " + object4.size() + " latest source to file mappings from database");
            } else {
                object4 = Util.dateOffset(this.itsPerfFilesConfig.getLastPerfFileEvent(), 60, 12);
                if (new Date().after((Date)object4)) {
                    try {
                        list = this.itsPerfFilesConfig.getDatabaseUpdates();
                        DbManager.upsertObjects(connection, pdrMonitorDataInterchangePerfFile.class, null, "PDR_MONITOR_PERFORMANCE_FILES", list);
                        connection.commit();
                        Util_Logger.info(logger, "Updated " + list.size() + " rows of event data to table PDR_MONITOR_PERFORMANCE_FILES");
                        this.itsPerfFilesConfig.resetLastPerfFileEvent();
                    }
                    catch (Exception exception) {
                        Util_Logger.errorNoRaise(logger, "Error writing source to file mappings table PDR_MONITOR_PERFORMANCE_FILES: " + exception.getMessage(), exception);
                    }
                }
            }
            if (this.itsCacheRefreshOnSave) {
                object4 = pdrMonitorCollectorManager.getInstance();
                ((pdrMonitorCollectorManager)object4).startCollectors();
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error loading monitor source data from database: " + exception.getMessage(), exception);
        }
        finally {
            DbManager.freeDbConnection(connection);
        }
    }

    public List<pdrMonitorSource> getSources() {
        return new ArrayList<pdrMonitorSource>(this.itsSources.values());
    }

    public pdrMonitorSource getSource(int n) {
        return this.itsSources.get(n);
    }

    public pdrMonitorSource getSource(String string, int n) {
        pdrMonitorSource pdrMonitorSource2 = null;
        for (pdrMonitorSource pdrMonitorSource3 : this.getSources()) {
            if (!pdrMonitorSource3.Hostname.equalsIgnoreCase(string) || pdrMonitorSource3.Port != n) continue;
            pdrMonitorSource2 = pdrMonitorSource3;
            break;
        }
        return pdrMonitorSource2;
    }

    public List<pdrMonitorDataInterchangePerfSLA> getPerfSLAConfig() {
        return new ArrayList<pdrMonitorDataInterchangePerfSLA>(this.itsPerfSLAConfig.values());
    }

    public List<pdrMonitorLatestDataConfig> getLatestDataConfig() {
        return new ArrayList<pdrMonitorLatestDataConfig>(this.itsLatestDataConfig.values());
    }

    public pdrMonitorDataInterchangePerfSLA getPerfConfig(String string) {
        if (string == null) {
            return null;
        }
        return this.itsPerfSLAConfig.get(string.toUpperCase());
    }

    public List<pdrMonitorDataInterchangePerfFile> getPerfFile(Integer n) {
        if (n == null) {
            return null;
        }
        if (this.itsPerfFilesConfig == null) {
            return null;
        }
        return this.itsPerfFilesConfig.getPerfFile(n);
    }

    public void addPerfFileEvent(int n, String string) {
        if (string != null && this.itsPerfFilesConfig != null) {
            this.itsPerfFilesConfig.addPerfFileEvent(n, string);
        }
    }

    public List<pdrMonitorSource> getSources(String string, String string2, String string3, Integer n) throws Exception {
        ArrayList<pdrMonitorSource> arrayList = new ArrayList<pdrMonitorSource>();
        for (pdrMonitorSource pdrMonitorSource2 : this.itsSources.values()) {
            if (!pdrMonitorSource2.System_Id.equalsIgnoreCase(string) || !pdrMonitorSource2.App_Name.equalsIgnoreCase(string2) || !pdrMonitorSource2.Instance_Id.equalsIgnoreCase(string3)) continue;
            boolean bl = n != null ? n == pdrMonitorSource2.pdr_monitor_id : true;
            boolean bl2 = bl;
            if (!bl2) continue;
            arrayList.add(pdrMonitorSource2);
        }
        if (arrayList.isEmpty()) {
            throw new Exception("Unable to find data source for application " + string2 + " instance " + string3 + " in system " + string);
        }
        return arrayList;
    }

    public pdrMonitorSource getActiveSource(String string, String string2, String string3, Integer n) throws Exception {
        Util_Logger.debug(logger, "Received request for " + string + "/" + string2 + "/" + string3 + ":" + n);
        pdrMonitorSource pdrMonitorSource2 = null;
        for (pdrMonitorSource pdrMonitorSource3 : this.itsSources.values()) {
            if (!pdrMonitorSource3.System_Id.equalsIgnoreCase(string) || !pdrMonitorSource3.App_Name.equalsIgnoreCase(string2) || !pdrMonitorSource3.Instance_Id.equalsIgnoreCase(string3)) continue;
            boolean bl = n != null ? n == pdrMonitorSource3.pdr_monitor_id : true;
            boolean bl2 = bl;
            if (!bl2) continue;
            if (pdrMonitorSource2 == null) {
                pdrMonitorSource2 = pdrMonitorSource3;
                continue;
            }
            if (!pdrMonitorSource3.LastActive.after(pdrMonitorSource2.LastActive)) continue;
            pdrMonitorSource2 = pdrMonitorSource3;
        }
        if (pdrMonitorSource2 == null) {
            throw new Exception("Unable to find data source for application " + string2 + " instance " + string3 + " in system " + string);
        }
        return pdrMonitorSource2;
    }

    public List<String> getInstances(String string, String string2) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (pdrMonitorSource pdrMonitorSource2 : this.itsSources.values()) {
            if (!pdrMonitorSource2.System_Id.equalsIgnoreCase(string) || !pdrMonitorSource2.App_Name.equalsIgnoreCase(string2) || arrayList.contains(pdrMonitorSource2.Instance_Id)) continue;
            arrayList.add(pdrMonitorSource2.Instance_Id);
        }
        if (arrayList.isEmpty()) {
            throw new Exception("Unable to find instances for application " + string2 + " in system " + string);
        }
        return arrayList;
    }

    public List<pdrMonitorSource> getInstallations(String string, String string2, String string3) throws Exception {
        ArrayList<pdrMonitorSource> arrayList = new ArrayList<pdrMonitorSource>();
        for (pdrMonitorSource pdrMonitorSource2 : this.itsSources.values()) {
            if (!pdrMonitorSource2.System_Id.equalsIgnoreCase(string) || !pdrMonitorSource2.App_Name.equalsIgnoreCase(string2) || !pdrMonitorSource2.Instance_Id.equalsIgnoreCase(string3)) continue;
            arrayList.add(pdrMonitorSource2);
        }
        if (arrayList.isEmpty()) {
            throw new Exception("Unable to find instances for application " + string2 + " with instance ID " + string3 + " in system " + string);
        }
        return arrayList;
    }

    public List<pdrMonitorSystem> getSystems() {
        if (this.itsSystems == null) {
            return new ArrayList<pdrMonitorSystem>();
        }
        return new ArrayList<pdrMonitorSystem>(this.itsSystems.values());
    }

    public pdrMonitorSystem getSystem(String string) throws Exception {
        if (this.itsSystems == null) {
            throw new Exception("Unable to find any systems registered in application");
        }
        if (this.itsSystems.isEmpty()) {
            throw new Exception("Unable to find any systems registered in application");
        }
        if (string == null) {
            return null;
        }
        return this.itsSystems.get(string.toUpperCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSystem(pdrMonitorSystem pdrMonitorSystem2) throws Exception {
        Connection connection = null;
        try {
            connection = DbManager.getDbConnection();
            if (pdrMonitorSystem2.Grants != null) {
                for (pdrMonitorSystemGrants pdrMonitorSystemGrants2 : pdrMonitorSystem2.Grants) {
                    pdrMonitorSystemGrants2.System_Id = pdrMonitorSystem2.System_Id;
                }
            }
            DbManager.upsertObject(connection, pdrMonitorSystem.class, null, "PDR_MONITOR_SYSTEM", pdrMonitorSystem2);
            DbManager.upsertObjects(connection, pdrMonitorSystemGrants.class, null, "PDR_MONITOR_SYSTEM_GRANTS", pdrMonitorSystem2.Grants);
            connection.commit();
            Util_Logger.info(logger, "Successfully saved system [" + pdrMonitorSystem2.System_Id + "]");
            if (this.itsCacheRefreshOnSave) {
                this.loadFromDatabase();
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Failed to save system: " + exception.getMessage(), exception);
        }
        finally {
            DbManager.freeDbConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveSource(pdrMonitorSource pdrMonitorSource2) throws Exception {
        Connection connection = null;
        try {
            connection = DbManager.getDbConnection();
            boolean bl = false;
            if (pdrMonitorSource2.pdr_monitor_id == null) {
                bl = true;
                for (pdrMonitorSource object : this.getSources()) {
                    if (pdrMonitorSource2.pdr_monitor_id == null) {
                        pdrMonitorSource2.pdr_monitor_id = object.pdr_monitor_id + 1;
                        continue;
                    }
                    pdrMonitorSource2.pdr_monitor_id = Math.max(pdrMonitorSource2.pdr_monitor_id, object.pdr_monitor_id + 1);
                }
                if (pdrMonitorSource2.pdr_monitor_id == null) {
                    pdrMonitorSource2.pdr_monitor_id = 1;
                }
            }
            if (bl) {
                boolean bl2 = false;
                for (pdrMonitorSource pdrMonitorSource3 : this.getSources()) {
                    if (pdrMonitorSource2.Port != pdrMonitorSource3.Port || !pdrMonitorSource2.Hostname.equalsIgnoreCase(pdrMonitorSource3.Hostname)) continue;
                    bl2 = true;
                }
                if (bl2) {
                    throw new Exception("Detected duplicate host and port definition, source already exists");
                }
            }
            if (Util.isBlank(pdrMonitorSource2.App_Label)) {
                pdrMonitorSource2.App_Label = pdrMonitorSource2.Hostname + ":" + pdrMonitorSource2.Port;
            }
            if (bl) {
                DbManager.insertObject(connection, pdrMonitorSource.class, null, "PDR_MONITOR_SOURCE", pdrMonitorSource2);
            } else {
                DbManager.updateObject(connection, pdrMonitorSource.class, null, "PDR_MONITOR_SOURCE", pdrMonitorSource2);
            }
            connection.commit();
            Util_Logger.info(logger, "Successfully saved source [" + pdrMonitorSource2.Hostname + ":" + pdrMonitorSource2.Port + ", app=" + pdrMonitorSource2.App_Name + ", instance=" + pdrMonitorSource2.Instance_Id + "]");
            if (this.itsCacheRefreshOnSave) {
                this.loadFromDatabase();
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Failed to save source: " + exception.getMessage(), exception);
        }
        finally {
            DbManager.freeDbConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void savePerfConfig(pdrMonitorDataInterchangePerfSLA pdrMonitorDataInterchangePerfSLA2) throws Exception {
        Connection connection = null;
        try {
            connection = DbManager.getDbConnection();
            DbManager.upsertObject(connection, pdrMonitorDataInterchangePerfSLA.class, null, "PDR_MONITOR_PERFORMANCE_CONFIG", pdrMonitorDataInterchangePerfSLA2);
            connection.commit();
            Util_Logger.info(logger, "Successfully saved SLA [" + pdrMonitorDataInterchangePerfSLA2.FileId + "], new SLA is " + pdrMonitorDataInterchangePerfSLA2.EndToEndSLA);
            if (this.itsCacheRefreshOnSave) {
                this.loadFromDatabase();
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Failed to save SLA: " + exception.getMessage(), exception);
        }
        finally {
            DbManager.freeDbConnection(connection);
        }
    }

    public WebClient createWebClient() {
        WebClient webClient = new WebClient().setTimeoutConnectionSecs(this.itsConfig.Monitor.TimeoutConnectionSecs).setTimeoutTransferSecs(this.itsConfig.Monitor.TimeoutTransferSecs).setProxy(this.itsConfig.Monitor.WebProxyAddress, this.itsConfig.Monitor.WebProxyPort).setUseDefaultSSLContext(false);
        webClient.setUUID(ApplicationManager.getInstance().getUUID());
        return webClient;
    }

    public WebServerConnectivity validateProtocol(pdrMonitorSource pdrMonitorSource2) throws Exception {
        if (Util.isBlank(pdrMonitorSource2.Hostname)) {
            throw new Exception("Hostname parameter is missing");
        }
        if (pdrMonitorSource2.Port <= 0) {
            throw new Exception("Port parameter is missing");
        }
        CertificateManager certificateManager = CertificateManager.getInstance();
        WebServerConnectivity webServerConnectivity = certificateManager.fetchCertificateFromServer(pdrMonitorSource2.Hostname, pdrMonitorSource2.Port);
        if (!webServerConnectivity.PortIsActive) {
            throw new Exception("Unable to connect to host/port");
        }
        if (Util.intToBoolean(pdrMonitorSource2.IsActive) && webServerConnectivity.Certificates != null && webServerConnectivity.Certificates.size() > 0) {
            try {
                pdrMonitorConfigManager pdrMonitorConfigManager2 = pdrMonitorConfigManager.getInstance();
                String string = Util.intToBoolean(pdrMonitorSource2.IsHttps) ? "https" : "http";
                String string2 = string + "://" + pdrMonitorSource2.Hostname + ":" + pdrMonitorSource2.Port + "/api/web/certificates";
                WebClient webClient = pdrMonitorConfigManager2.createWebClient();
                webClient.setAuthProvider(new WebClientAuthHMAC().setAPIKey(pdrMonitorSource2.API_Key));
                WebHttpResponse webHttpResponse = webClient.doGet(string2, null);
                if (webHttpResponse.ReturnCode != 200) {
                    throw new Exception("Unable to fetch certificates from host:" + webHttpResponse.Body);
                }
                CertificateList certificateList = JsonUtilities.fromJson(webHttpResponse.Body, CertificateList.class);
                webServerConnectivity.Certificates = certificateList.Certificates;
                CertificateManager.getInstance().identifyTrustedCertificates(webServerConnectivity.Certificates);
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Unable to extract certificates via application API: " + exception.getMessage(), exception);
            }
        }
        return webServerConnectivity;
    }

    @SuppressFBWarnings(value={"NP_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "DLS_DEAD_LOCAL_STORE"})
    public pdrMonitorSourceCheck validateSource(pdrMonitorSource pdrMonitorSource2) throws Exception {
        if (Util.isBlank(pdrMonitorSource2.Hostname)) {
            throw new Exception("Hostname parameter is missing");
        }
        if (Util.isBlank(pdrMonitorSource2.API_Key)) {
            throw new Exception("API_Key parameter is missing");
        }
        if (pdrMonitorSource2.Port <= 0) {
            throw new Exception("Port parameter is invalid");
        }
        if (!Util.isHex(pdrMonitorSource2.API_Key)) {
            throw new Exception("API_Key parameter must be a hexadecimal string");
        }
        CertificateManager certificateManager = CertificateManager.getInstance();
        if (!certificateManager.serverListening(pdrMonitorSource2.Hostname, pdrMonitorSource2.Port)) {
            throw new Exception("Unable to connect to host/port");
        }
        pdrMonitorConfigManager pdrMonitorConfigManager2 = pdrMonitorConfigManager.getInstance();
        pdrMonitorSourceCheck pdrMonitorSourceCheck2 = new pdrMonitorSourceCheck();
        String string = Util.intToBoolean(pdrMonitorSource2.IsHttps) ? "https" : "http";
        String string2 = string + "://" + pdrMonitorSource2.Hostname + ":" + pdrMonitorSource2.Port + "/api/app/about";
        WebClient webClient = pdrMonitorConfigManager2.createWebClient();
        webClient.setAuthProvider(new WebClientAuthHMAC().setAPIKey(pdrMonitorSource2.API_Key));
        WebHttpResponse webHttpResponse = webClient.doGet(string2, null);
        if (webHttpResponse.ReturnCode != 200) {
            Util_Logger.debug(logger, "Unable to connect to [" + string2 + "] for source application check, response code is " + webHttpResponse.ReturnCode + ", message is " + webHttpResponse.Body);
            throw new Exception("Unable to connect to web service, check:\n* API key\n* Allow port access\n* Time difference between the monitoring host and the target host\n" + webHttpResponse.Body);
        }
        pdrMonitorSourceCheck2 = JsonUtilities.fromJson(webHttpResponse.Body, pdrMonitorSourceCheck.class);
        string2 = string + "://" + pdrMonitorSource2.Hostname + ":" + pdrMonitorSource2.Port + "/api/app/configuration";
        webClient.setAuthProvider(new WebClientAuthHMAC().setAPIKey(pdrMonitorSource2.API_Key));
        webHttpResponse = webClient.doGet(string2, null);
        if (webHttpResponse.ReturnCode == 200) {
            PropItemCollection propItemCollection = JsonUtilities.fromJson(webHttpResponse.Body, PropItemCollection.class);
            for (PropItem propItem : propItemCollection.properties) {
                if (!propItem.Name.equalsIgnoreCase("instance_identifier")) continue;
                pdrMonitorSourceCheck2.App.InstanceId = propItem.Value;
            }
        } else {
            throw new Exception(webHttpResponse.Body);
        }
        return pdrMonitorSourceCheck2;
    }

    public String cycleHMACKey(int n) throws Exception {
        String string;
        String string2 = null;
        pdrMonitorSource pdrMonitorSource2 = this.getSource(n);
        if (pdrMonitorSource2 != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(pdrMonitorSource2.getBaseURL());
            stringBuilder.append("/api/web/hmackey");
            int n2 = pdrMonitorSource2.API_Key.length() * 4;
            string = KeyManager.generateKey(n2);
            WebClient webClient = this.createWebClient();
            webClient.setAuthProvider(new WebClientAuthHMAC().setAPIKey(pdrMonitorSource2.API_Key));
            WebHttpResponse webHttpResponse = webClient.doPost(stringBuilder.toString(), null, WebContent.MediaType.TEXT_PLAIN, string);
            if (webHttpResponse.ReturnCode != 200) {
                throw new Exception(webHttpResponse.Body);
            }
            string2 = webHttpResponse.Body;
        } else {
            throw new Exception("Invalid source ID");
        }
        pdrMonitorSource2.API_Key = string;
        this.saveSource(pdrMonitorSource2);
        return string2;
    }

    private static class SingletonHolder {
        private static pdrMonitorConfigManager instance = new pdrMonitorConfigManager();

        private SingletonHolder() {
        }
    }

    @SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "SIC_INNER_SHOULD_BE_STATIC"})
    private class PropItemCollection {
        public List<PropItem> properties = new ArrayList<PropItem>();

        private PropItemCollection() {
        }
    }

    @SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "SIC_INNER_SHOULD_BE_STATIC"})
    private class PropItem {
        public String Name;
        public String Value;

        private PropItem() {
        }
    }
}

