/*==============================================================*/
/* Data Model:     AEMO Gas Data Model v2.2.1 Oracle            */
/* Created on:     2025/01/24 13:55:44                          */
/*==============================================================*/


/*==============================================================*/
/* Table: GAS_BLEND_CURTAILMENT                                 */
/*==============================================================*/
create table GAS_BLEND_CURTAILMENT (
   GASYEAR              NUMBER(4,0)           not null,
   MONTHNO              NUMBER(4,0)           not null,
   FACILITYID           NUMBER(10,0)          not null,
   VERSIONDATETIME      DATE                  not null,
   CONNECTIONPOINTID    NUMBER(10,0)          not null,
   FLOWDIRECTION        VARCHAR2(20)          not null,
   BLENDCURTAILEVENTS   NUMBER(20,0),
   BLENDCURTAILQTY      NUMBER(18,3),
   BLENDHIGH            NUMBER(18,3),
   BLENDLOW             NUMBER(18,3),
   BLENDAVG             NUMBER(18,3),
   GASTYPE              VARCHAR2(200),
   BLENDLIMIT           NUMBER(18,3),
   MAXGASDATE           DATE,
   MINGASDATE           DATE,
   LASTCHANGED          DATE
)
   tablespace GASTAB02;

comment on table GAS_BLEND_CURTAILMENT is
'A table with details of gas blend and gas blend curtailment information';

comment on column GAS_BLEND_CURTAILMENT.GASYEAR is
'Year the information applies to';

comment on column GAS_BLEND_CURTAILMENT.MONTHNO is
'Month the information applies to';

comment on column GAS_BLEND_CURTAILMENT.FACILITYID is
'Unique Facility Identifier';

comment on column GAS_BLEND_CURTAILMENT.VERSIONDATETIME is
'Version timestamp of the record';

comment on column GAS_BLEND_CURTAILMENT.CONNECTIONPOINTID is
'A unique AEMO defined connection point identifier';

comment on column GAS_BLEND_CURTAILMENT.FLOWDIRECTION is
'Direction of flow for the submission record. Must be one of RECEIPT or DELIVERY';

comment on column GAS_BLEND_CURTAILMENT.BLENDCURTAILEVENTS is
'The number of times a gas blend curtailment has occurred in a month to the BB facility or part of it';

comment on column GAS_BLEND_CURTAILMENT.BLENDCURTAILQTY is
'Quantity of gas curtailed in TJ';

comment on column GAS_BLEND_CURTAILMENT.BLENDHIGH is
'Highest blend level reached in %vol on any gas day in the month';

comment on column GAS_BLEND_CURTAILMENT.BLENDLOW is
'Lowest blend level reached in %vol on any gas day in the month';

comment on column GAS_BLEND_CURTAILMENT.BLENDAVG is
'The average daily blend level across all gas days in the month provided in %vol terms';

comment on column GAS_BLEND_CURTAILMENT.GASTYPE is
'Primary gas added to the gas blend';

comment on column GAS_BLEND_CURTAILMENT.BLENDLIMIT is
'Blend level limit applied for the gas day in %vol';

comment on column GAS_BLEND_CURTAILMENT.MAXGASDATE is
'Gas date in the month when the highest blend level was achieved';

comment on column GAS_BLEND_CURTAILMENT.MINGASDATE is
'Gas date in the month when the lowest blend level was achieved';

comment on column GAS_BLEND_CURTAILMENT.LASTCHANGED is
'Date and time record was last modified';

alter table GAS_BLEND_CURTAILMENT
   add constraint GAS_BLEND_CURTAILMENT_PK primary key (GASYEAR, MONTHNO, FACILITYID, VERSIONDATETIME, CONNECTIONPOINTID, FLOWDIRECTION)
      using index tablespace GASIND02;

comment on column GAS_CONTACT_DETAIL.VERSIONDATETIME is
'Version timestamp of the record';

comment on column GAS_CONTACT_DETAIL.AUTHORISEDBY is
'AEMO internal';

comment on column GAS_DEVFACILITY_DETAIL.VERSIONDATETIME is
'Version timestamp of the record';

comment on column GAS_DEVFACILITY_DETAIL.AUTHORISEDBY is
'AEMO internal';

comment on column GAS_FACILITY.FACILITYTYPE is
'Describes the type of facility. Refer to the GAS_FACILITY_TYPE table';

comment on column GAS_FACILITY_DETAIL.AUTHORISEDBY is
'AEMO internal';

comment on column GAS_FACILITY_DETAIL_CAPACITY.VERSIONDATETIME is
'Version timestamp of the record';

comment on column GAS_FACILITY_DETAIL_CAPACITY.AUTHORISEDBY is
'AEMO internal';

comment on column GAS_FACILITY_NODE_TRK.AUTHORISEDBY is
'AEMO internal';

comment on column GAS_FACILITY_OPSTATE.AUTHORISEDBY is
'AEMO internal';

comment on column GAS_FACILITY_OWNER.VERSIONDATETIME is
'Version timestamp of the record';

comment on column GAS_FACILITY_OWNER_TRK.VERSIONDATETIME is
'Version timestamp of the record';

comment on column GAS_FACILITY_OWNER_TRK.AUTHORISEDBY is
'AEMO internal';

comment on column GAS_FACILITY_SUMMARY.FACILITYTYPE is
'Describes the type of facility. Refer to the GAS_FACILITY_TYPE table';

comment on column GAS_LINEPACK_ADEQUACY.VERSIONDATETIME is
'Version timestamp of the record';

comment on column GAS_LOCATION_NODE_TRK.AUTHORISEDBY is
'AEMO internal';

comment on column GAS_LOCATION_OPSTATE.AUTHORISEDBY is
'AEMO internal';

comment on column GAS_NODE_OPSTATE.AUTHORISEDBY is
'AEMO internal';

comment on column GAS_PARTICIPANT_CONTACT.VERSIONDATETIME is
'Version timestamp of the record';

comment on column GAS_PARTICIPANT_CONTACT_TRK.VERSIONDATETIME is
'Version timestamp of the record';

comment on column GAS_PARTICIPANT_CONTACT_TRK.AUTHORISEDBY is
'AEMO internal';

comment on column GAS_PARTICIPANT_DETAIL.VERSIONDATETIME is
'Version timestamp of the record';

comment on column GAS_PARTICIPANT_DETAIL.AUTHORISEDBY is
'AEMO internal';

comment on column GAS_PARTICIPANT_OPSTATE.VERSIONDATETIME is
'Version timestamp of the record';

comment on column GAS_PARTICIPANT_OPSTATE.AUTHORISEDBY is
'AEMO internal';

alter table GAS_SHORT_TERM_SWAP_TRANS modify QUANTITY NUMBER(22,8);

alter table GAS_SHORT_TERM_TRANS modify QUANTITY NUMBER(22,8);

